/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.container.netty;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.pointcuts.container.netty.NettyHttpRequest;
import com.newrelic.agent.util.IteratorEnumeration;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.Request;
import java.net.HttpCookie;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingNettyHttpRequest
implements Request {
    public static final String COOKIE_HEADER_NAME = "Cookie";
    private final NettyHttpRequest delegate;
    private volatile Map<String, String> cookies;
    private volatile Map<String, List<Object>> parameters;

    private DelegatingNettyHttpRequest(NettyHttpRequest delegate) {
        this.delegate = delegate;
    }

    public HeaderType getHeaderType() {
        return HeaderType.HTTP;
    }

    private Map<String, String> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
            List<String> cookieHeaders = this.delegate.getHeaders(COOKIE_HEADER_NAME);
            for (String cookieHeader : cookieHeaders) {
                List<HttpCookie> httpCookies;
                try {
                    httpCookies = HttpCookie.parse(cookieHeader);
                }
                catch (IllegalArgumentException e) {
                    httpCookies = new LinkedList<HttpCookie>();
                    for (String part : cookieHeader.split(";")) {
                        try {
                            httpCookies.addAll(HttpCookie.parse(part));
                        }
                        catch (IllegalArgumentException e1) {
                            Agent.LOG.fine("Failed to parse Cookie part: " + part);
                        }
                    }
                }
                for (HttpCookie httpCookie : httpCookies) {
                    this.cookies.put(httpCookie.getName(), httpCookie.getValue());
                }
            }
        }
        return this.cookies;
    }

    public void setParameters(Map<String, List<Object>> params) {
        this.parameters = params;
    }

    public Enumeration<?> getParameterNames() {
        if (this.parameters == null) {
            return null;
        }
        Iterator<String> it = this.parameters.keySet().iterator();
        return new IteratorEnumeration<String>(it);
    }

    public String[] getParameterValues(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name) == null ? null : this.parameters.get(name).toArray(new String[0]);
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String getRequestURI() {
        return this.delegate.getUri();
    }

    public String getHeader(String name) {
        List<String> nameHeaders = this.delegate.getHeaders(name);
        if (nameHeaders != null && nameHeaders.size() > 0) {
            return nameHeaders.get(0);
        }
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getCookieValue(String name) {
        Map<String, String> map = this.getCookies();
        if (map == null) {
            return null;
        }
        return map.get(name);
    }

    static Request create(NettyHttpRequest delegate) {
        return new DelegatingNettyHttpRequest(delegate);
    }
}

