/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.OrMethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.database.CreatePreparedStatementTracerFactory;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.tracers.TracerFactory;
import java.util.ArrayList;
import java.util.Set;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class CreatePreparedStatementPointCut
extends PointCut {
    public static final String CONNECTION_INTERFACE = "java/sql/Connection";
    private static final String MYSQL_CONNECTION_CLASS = "com/mysql/jdbc/Connection";
    static final MethodMatcher METHOD_MATCHER = OrMethodMatcher.getMethodMatcher(new ExactMethodMatcher("prepareStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;"), new ExactMethodMatcher("prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;"));
    private final TracerFactory tracerFactory = new CreatePreparedStatementTracerFactory();

    public CreatePreparedStatementPointCut(ClassTransformer classTransformer) {
        this(ServiceFactory.getConfigService().getDefaultAgentConfig());
    }

    private CreatePreparedStatementPointCut(AgentConfig config) {
        super(new PointCutConfiguration("jdbc_prepare_statement", null, CreatePreparedStatementPointCut.isEnabledByDefault()), CreatePreparedStatementPointCut.getClassMatcher(config), METHOD_MATCHER);
    }

    protected static boolean isEnabledByDefault() {
        Set<String> jdbcSupport = ServiceFactory.getConfigService().getDefaultAgentConfig().getJDBCSupport();
        return jdbcSupport.size() != 1 || !jdbcSupport.contains("mysql");
    }

    protected boolean isDispatcher() {
        return true;
    }

    private static ClassMatcher getClassMatcher(AgentConfig agentConfig) {
        ArrayList<ClassMatcher> matchers = new ArrayList<ClassMatcher>(2);
        if (agentConfig.isGenericJDBCSupportEnabled()) {
            matchers.add(new InterfaceMatcher(CONNECTION_INTERFACE));
        }
        matchers.add(new ExactClassMatcher(MYSQL_CONNECTION_CLASS));
        matchers.add(new ExactClassMatcher("oracle/jdbc/driver/PhysicalConnection"));
        matchers.add(new ExactClassMatcher("oracle/jdbc/OracleConnectionWrapper"));
        return OrClassMatcher.getClassMatcher(matchers.toArray(new ClassMatcher[0]));
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this.tracerFactory;
    }
}

