/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.database.DatabaseVendor;
import com.newrelic.agent.database.RecordSql;
import com.newrelic.agent.instrumentation.pointcuts.database.ExplainPlanExecutor;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;

public class DefaultExplainPlanExecutor
implements ExplainPlanExecutor {
    private ISqlStatementTracer tracer;
    private final String originalSqlStatement;
    private final RecordSql recordSql;

    public DefaultExplainPlanExecutor(ISqlStatementTracer tracer, String originalSqlStatement, RecordSql recordSql) {
        this.originalSqlStatement = originalSqlStatement;
        this.tracer = tracer;
        this.recordSql = recordSql;
    }

    private Object[] getExplainPlanFromResultSet(DatabaseVendor vendor, ResultSet rs, RecordSql recordSql) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        if (columnCount > 0) {
            Collection<Collection<Object>> explains = vendor.parseExplainPlanResultSet(columnCount, rs, recordSql);
            return new Object[]{explains};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runExplainPlan(DatabaseService databaseService, Connection connection, DatabaseVendor vendor) throws SQLException {
        Object[] explainPlan;
        block22: {
            Exception e322;
            Statement statement;
            ResultSet resultSet;
            block20: {
                String sql = this.originalSqlStatement;
                try {
                    sql = vendor.getExplainPlanSql(sql);
                }
                catch (SQLException e2) {
                    this.tracer.setExplainPlan(e2.getMessage());
                    return;
                }
                Agent.LOG.finer("Running explain: " + sql);
                resultSet = null;
                statement = null;
                explainPlan = null;
                statement = this.createStatement(connection, sql);
                resultSet = this.executeStatement(statement, sql);
                explainPlan = this.getExplainPlanFromResultSet(vendor, resultSet, this.recordSql);
                Object var10_9 = null;
                if (resultSet == null) break block20;
                try {
                    resultSet.close();
                }
                catch (Exception e322) {
                    Agent.LOG.log(Level.FINER, "Unable to close result set", e322);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e322) {
                    Agent.LOG.log(Level.FINER, "Unable to close statement", e322);
                }
            }
            break block22;
            {
                catch (Exception e4) {
                    Exception e322;
                    explainPlan = new Object[]{"An error occurred running explain plan : " + e4.getMessage()};
                    Agent.LOG.log(Level.FINER, "explain plan error", e4);
                    Object var10_10 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception e322) {
                            Agent.LOG.log(Level.FINER, "Unable to close result set", e322);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception e322) {
                            Agent.LOG.log(Level.FINER, "Unable to close statement", e322);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e322;
                Object var10_11 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception e322) {
                        Agent.LOG.log(Level.FINER, "Unable to close result set", e322);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception e322) {
                        Agent.LOG.log(Level.FINER, "Unable to close statement", e322);
                    }
                }
                throw throwable;
            }
        }
        if (explainPlan != null) {
            this.tracer.setExplainPlan(explainPlan);
        }
    }

    protected ResultSet executeStatement(Statement statement, String sql) throws SQLException {
        return statement.executeQuery(sql);
    }

    protected Statement createStatement(Connection connection, String sql) throws SQLException {
        return connection.createStatement();
    }
}

