/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class PlayTemplateLoaderPointCut
extends TracerFactoryPointCut {
    private static final String POINT_CUT_NAME = PlayTemplateLoaderPointCut.class.getName();
    private static final String TEMPLATE_LOADER_CLASS = "play/templates/TemplateLoader";
    private static final String LOAD_METHOD = "load";
    private static final String LOAD_DESC = "(Ljava/lang/String;)Lplay/templates/Template;";
    private static final String PLAY_TEMPLATE = "PlayTemplate";

    public PlayTemplateLoaderPointCut(ClassTransformer classTransformer) {
        super(PlayTemplateLoaderPointCut.createPointCutConfig(), PlayTemplateLoaderPointCut.createClassMatcher(), PlayTemplateLoaderPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "play_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(TEMPLATE_LOADER_CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(LOAD_METHOD, LOAD_DESC);
    }

    public Tracer getTracer(Transaction tx, ClassMethodSignature sig, Object object, Object[] args) {
        if (tx.getDispatcher() != null && tx.isTransactionNamingEnabled()) {
            String templatePath = (String)args[0];
            this.setTransactionName(tx, templatePath);
        }
        return null;
    }

    private void setTransactionName(Transaction tx, String templatePath) {
        TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(tx, TransactionNamePriority.FRAMEWORK_HIGH)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Play template", templatePath);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(tx, templatePath, PLAY_TEMPLATE, TransactionNamePriority.FRAMEWORK_HIGH);
    }
}

