/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.play2;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.play2.HandlerDef;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class Play2RoutingPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final String PLAY_INSTRUMENTATION_GROUP_NAME = "play2_instrumentation";
    private static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = Play2RoutingPointCut.class.getName();
    static final String CLASS = "play/core/Router$Routes$class";
    static final String METHOD_NAME = "invokeHandler";
    static final String METHOD_DESC = "(Lplay/core/Router$Routes;Lscala/Function0;Lplay/core/Router$HandlerDef;Lplay/core/Router$HandlerInvoker;)Lplay/api/mvc/Handler;";

    public Play2RoutingPointCut(ClassTransformer classTransformer) {
        super(Play2RoutingPointCut.createPointCutConfig(), Play2RoutingPointCut.createClassMatcher(), Play2RoutingPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, PLAY_INSTRUMENTATION_GROUP_NAME, true);
    }

    private static ClassMatcher createClassMatcher() {
        return new ExactClassMatcher(CLASS);
    }

    private static MethodMatcher createMethodMatcher() {
        return new ExactMethodMatcher(METHOD_NAME, METHOD_DESC);
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (!Transaction.hasTransaction() || !Transaction.getTransaction().isStarted()) {
            return;
        }
        Transaction tx = Transaction.getTransaction();
        if (args[2] instanceof HandlerDef) {
            HandlerDef handlerDef = (HandlerDef)args[2];
            this.setTransactionName(tx, handlerDef);
        } else {
            this.setTransactionName(tx, "UNKNOWN");
        }
    }

    private void setTransactionName(Transaction tx, HandlerDef handlerDef) {
        String action = handlerDef.controller() + "." + handlerDef.method();
        this.setTransactionName(tx, action);
    }

    private void setTransactionName(Transaction tx, String controllerAction) {
        if (!tx.isTransactionNamingEnabled()) {
            return;
        }
        TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(tx, TransactionNamePriority.FRAMEWORK_LOW)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using Play 2 controller action", controllerAction);
            Agent.LOG.finer(msg);
        }
        policy.setTransactionName(tx, controllerAction, "PlayControllerAction", TransactionNamePriority.FRAMEWORK_LOW);
    }
}

