/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.scala;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionHolder;
import com.newrelic.agent.async.AsyncTransactionState;
import com.newrelic.agent.instrumentation.ClassTransformer;
import com.newrelic.agent.instrumentation.FieldAccessor;
import com.newrelic.agent.instrumentation.InterfaceMixin;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OrClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NameMethodMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.EntryInvocationHandler;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.lang.reflect.Field;
import java.text.MessageFormat;

@com.newrelic.agent.instrumentation.pointcuts.PointCut
public class TransactionHolderInitPointCut
extends PointCut
implements EntryInvocationHandler {
    public static final boolean DEFAULT_ENABLED = true;
    private static final String POINT_CUT_NAME = TransactionHolderInitPointCut.class.getName();
    private final boolean tracerNamingEnabled = ServiceFactory.getConfigService().getTransactionTracerConfig(null).isStackBasedNamingEnabled();

    public TransactionHolderInitPointCut(ClassTransformer classTransformer) {
        super(TransactionHolderInitPointCut.createPointCutConfig(), TransactionHolderInitPointCut.createClassMatcher(), TransactionHolderInitPointCut.createMethodMatcher());
    }

    private static PointCutConfiguration createPointCutConfig() {
        return new PointCutConfiguration(POINT_CUT_NAME, "scala_instrumentation", true);
    }

    private static ClassMatcher createClassMatcher() {
        return OrClassMatcher.getClassMatcher(new ExactClassMatcher("scala/concurrent/impl/AbstractPromise"), new ExactClassMatcher("scala/concurrent/impl/CallbackRunnable"));
    }

    private static MethodMatcher createMethodMatcher() {
        return new NameMethodMatcher("<init>");
    }

    protected PointCutInvocationHandler getPointCutInvocationHandlerImpl() {
        return this;
    }

    public void handleInvocation(ClassMethodSignature sig, Object object, Object[] args) {
        if (object instanceof TransactionHolder) {
            TransactionHolder th = (TransactionHolder)object;
            if (Transaction.hasTransaction() && th._nr_getTransaction() == null) {
                Transaction tx = Transaction.getTransaction();
                if (!(tx.getTransactionState() instanceof AsyncTransactionState)) {
                    return;
                }
                th._nr_setTransaction(tx);
                if (this.tracerNamingEnabled) {
                    th._nr_setName(this.findTxName(th));
                }
                tx.getTransactionState().asyncJobStarted(th);
            }
        }
    }

    private String findTxName(TransactionHolder th) {
        if (th instanceof CallbackRunnable) {
            Object onComplete = ((CallbackRunnable)((Object)th)).onComplete();
            return this.analyzeOnComplete(onComplete);
        }
        for (StackTraceElement st : Thread.currentThread().getStackTrace()) {
            if (st.getClassName().startsWith("com.newrelic") || st.getMethodName().equals("<init>") || st.getClassName().startsWith("scala.concurrent") || st.getClassName().startsWith("scala.collection") || st.getClassName().startsWith("play.api.libs.concurrent") || st.getClassName().startsWith("play.api.libs.iteratee") || st.getClassName().startsWith("play.libs.F") || st.getClassName().startsWith("akka.pattern.PromiseActorRef") || st.getClassName().startsWith("java.util.concurrent.ThreadPoolExecutor") || st.getClassName().startsWith("java.lang.Thread")) continue;
            return MessageFormat.format("Java/{0}/{1}", st.getClassName(), st.getMethodName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String analyzeOnComplete(Object onComplete) {
        for (Field field : onComplete.getClass().getDeclaredFields()) {
            Object callback;
            boolean accessible;
            block6: {
                if (!field.getType().getName().startsWith("scala.Function")) continue;
                accessible = field.isAccessible();
                field.setAccessible(true);
                callback = field.get(onComplete);
                if (!callback.getClass().getName().startsWith("scala.concurrent") && !callback.getClass().getName().startsWith("play.api.libs.concurrent") && !callback.getClass().getName().startsWith("play.api.libs.iteratee")) break block6;
                String string = this.analyzeOnComplete(callback);
                Object var10_12 = null;
                field.setAccessible(accessible);
                return string;
            }
            try {
                String string = MessageFormat.format("Java/{0}/apply", callback.getClass().getName());
                Object var10_13 = null;
                field.setAccessible(accessible);
                return string;
            }
            catch (Exception e) {
                try {
                    String string = null;
                    Object var10_14 = null;
                    field.setAccessible(accessible);
                    return string;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    field.setAccessible(accessible);
                    throw throwable;
                }
            }
        }
        return MessageFormat.format("Java/{0}/apply", onComplete.getClass().getName());
    }

    @InterfaceMixin(originalClassName={"scala/concurrent/impl/CallbackRunnable"})
    public static interface CallbackRunnable {
        @FieldAccessor(fieldName="onComplete", fieldDesc="Lscala/Function1;", existingField=true)
        public Object onComplete();
    }
}

