/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Attribute;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Remapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.weaver.FixLoadClassMethodAdapter;
import com.newrelic.agent.instrumentation.weaver.IllegalInstructionException;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.MergeMethodVisitor;
import com.newrelic.agent.instrumentation.weaver.MixinClassVisitor;
import com.newrelic.agent.instrumentation.weaver.Verifier;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.org.objectweb.asm.commons.MethodCallInlinerAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

class ClassWeaver
extends ClassVisitor {
    private static final Remapper NO_OP_REMAPPER = new Remapper(){};
    private final Set<Method> originalMethods = new HashSet<Method>();
    private final String className;
    private final Map<Method, MergeMethodVisitor> methods;
    private final Map<String, FieldNode> newFields;
    private final Map<String, FieldNode> existingFields = Maps.newHashMap();
    private final Verifier verifier;
    private final MixinClassVisitor mixinClassVisitor;
    private final Map<Method, MergeMethodVisitor> newMethods;
    private boolean firstField = true;
    private final InstrumentationContext context;
    private final InstrumentationPackage instrumentationPackage;
    private int version;
    private static final String MAGIC_KEY_FOR_CONSTRUCTOR_INLINE = "____INLINE_ME____";

    public ClassWeaver(ClassVisitor cv, MixinClassVisitor mixinClassVisitor, String className, Verifier verifier, ClassStructure originalClassStructure, InstrumentationContext context, InstrumentationPackage instrumentationPackage, OptimizedClassMatcher.Match match) {
        super(327680, cv);
        TraceDetails traceDetails;
        this.verifier = verifier;
        this.className = className;
        this.mixinClassVisitor = mixinClassVisitor;
        this.methods = Maps.newHashMap(mixinClassVisitor.getMethods());
        HashMap<Method, TraceDetails> tracedMethods = Maps.newHashMap(mixinClassVisitor.getWeaveClassInfo().getTracedMethods());
        for (Map.Entry<Method, Method> entry : context.getBridgeMethods().entrySet()) {
            MergeMethodVisitor mv = this.methods.remove(entry.getKey());
            if (mv == null) continue;
            this.methods.put(entry.getValue(), mv);
            traceDetails = (TraceDetails)tracedMethods.remove(entry.getKey());
            if (traceDetails == null) continue;
            tracedMethods.put(entry.getValue(), traceDetails);
        }
        this.context = context;
        this.instrumentationPackage = instrumentationPackage;
        this.newFields = mixinClassVisitor.getWeaveClassInfo().getNewFields();
        this.newMethods = Maps.newHashMap(mixinClassVisitor.getMethods());
        for (Method method : originalClassStructure.getMethods()) {
            this.newMethods.remove(method);
        }
        HashSet toRemove = Sets.newHashSet();
        for (Method newMethod : this.newMethods.keySet()) {
            traceDetails = (TraceDetails)tracedMethods.get(newMethod);
            if (traceDetails == null) continue;
            Level level = MatchType.ExactClass.equals((Object)mixinClassVisitor.getMatchType()) ? Level.FINE : Level.FINER;
            instrumentationPackage.getLogger().log(level, newMethod + " is marked with a Trace annotation, but it does not exist on " + className + ".");
        }
        this.newMethods.keySet().removeAll(toRemove);
        context.addTracedMethods(tracedMethods);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.firstField) {
            this.firstField = false;
            for (InnerClassNode innerClass : this.mixinClassVisitor.getInnerClasses()) {
                if (this.mixinClassVisitor.isAbstractMatch() && !this.instrumentationPackage.getWeaveClasses().containsKey(innerClass.name) && this.instrumentationPackage.getClassBytes().keySet().contains(innerClass.name)) {
                    throw new IllegalInstructionException("Inner classes are not currently supported for abstract merged classes.  " + this.className + " : " + innerClass.name);
                }
                if (this.instrumentationPackage.isWeaved(innerClass.name) || !this.instrumentationPackage.matches(innerClass.name)) continue;
                this.visitInnerClass(innerClass.name, innerClass.outerName, innerClass.innerName, innerClass.access);
            }
        }
        FieldNode node = new FieldNode(access, name, desc, signature, value);
        this.existingFields.put(node.name, node);
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Method method = new Method(name, desc);
        this.originalMethods.add(method);
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x400) != 0) {
            this.methods.remove(method);
            return mv;
        }
        MergeMethodVisitor replayMethodVisitor = this.methods.get(method);
        if ("<init>".equals(name)) {
            if (!"()V".equals(desc) && replayMethodVisitor == null) {
                replayMethodVisitor = this.methods.get(new Method(name, "()V"));
            }
            if (replayMethodVisitor != null) {
                mv = new ConstructorMerger(access, mv, name, desc, signature, exceptions, replayMethodVisitor);
            }
            mv = this.mixinClassVisitor.getWeaveClassInfo().getConstructorMethodVisitor(mv, this.className, access, name, desc);
            replayMethodVisitor = null;
        }
        if (null != replayMethodVisitor) {
            this.methods.remove(method);
            if (replayMethodVisitor.isNewMethod()) {
                throw new IllegalInstructionException("Weaved method " + this.className + '.' + name + desc + " does not call the original method implementation");
            }
            this.instrumentationPackage.getLogger().fine("Injecting code into " + this.className + '.' + method);
            mv = new MethodMerger(access, mv, replayMethodVisitor, name, desc, signature, exceptions);
            this.context.addWeavedMethod(method, this.instrumentationPackage.getImplementationTitle());
        }
        mv = new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
        return mv;
    }

    private class MethodMerger
    extends MethodNode {
        private final MergeMethodVisitor codeToInject;
        private final MethodVisitor writer;
        private final String name;
        private final String desc;
        private final int access;
        private final Method method;

        public MethodMerger(int access, MethodVisitor mv, MergeMethodVisitor codeToInject, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.writer = mv;
            this.codeToInject = codeToInject;
            this.method = new Method(name, desc);
            this.name = name;
            this.desc = desc;
            this.access = access;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.writer.visitAnnotation(desc, visible);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this.writer.visitAnnotationDefault();
        }

        public void visitAttribute(Attribute attr) {
            this.writer.visitAttribute(attr);
        }

        public void visitEnd() {
            final HashMap<Method, MethodNode> methodsToInline = Maps.newHashMap(ClassWeaver.this.mixinClassVisitor.getMethodsToInline());
            this.instructions.resetLabels();
            this.codeToInject.instructions.resetLabels();
            for (MethodNode newCode : methodsToInline.values()) {
                newCode.instructions.resetLabels();
            }
            MethodVisitor mv = new MethodCallInlinerAdapter(ClassWeaver.this.className, this.access, this.name, this.desc, this.writer, false){

                protected MethodCallInlinerAdapter.InlinedMethod mustInline(String owner, String name, String desc) {
                    if (owner.equals(MethodMerger.this.codeToInject.getClassName()) && new Method(name, desc).equals(MethodMerger.this.codeToInject.getMethod())) {
                        ClassWeaver.this.instrumentationPackage.getLogger().finer("Inline original implementation of " + name + desc);
                        return new MethodCallInlinerAdapter.InlinedMethod(MethodMerger.this, NO_OP_REMAPPER);
                    }
                    return null;
                }
            };
            mv = ClassWeaver.this.mixinClassVisitor.getWeaveClassInfo().getMethodVisitor(ClassWeaver.this.className, mv, this.access, this.method);
            mv = new MethodCallInlinerAdapter(ClassWeaver.this.className, this.access, this.name, this.desc, mv, false){

                protected MethodCallInlinerAdapter.InlinedMethod mustInline(String owner, String name, String desc) {
                    MethodNode methodToInline = (MethodNode)methodsToInline.get(new Method(name, desc));
                    if (owner.equals(MethodMerger.this.codeToInject.getClassName()) && methodToInline != null) {
                        ClassWeaver.this.instrumentationPackage.getLogger().finer("Inlining " + name + desc);
                        return new MethodCallInlinerAdapter.InlinedMethod(methodToInline, NO_OP_REMAPPER);
                    }
                    return null;
                }
            };
            if (ClassWeaver.this.version < 49) {
                mv = new FixLoadClassMethodAdapter(this.access, this.method, mv);
            }
            this.codeToInject.accept(mv);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.writer.visitMaxs(0, 0);
        }
    }

    private class ConstructorMerger
    extends MethodNode {
        private final MethodVisitor writer;
        private final MethodNode newCode;
        private final Method method;

        public ConstructorMerger(int access, MethodVisitor mv, String name, String desc, String signature, String[] exceptions, MethodNode additionalCode) {
            super(327680, access, name, desc, signature, exceptions);
            this.method = new Method(name, desc);
            MethodVisitor codeVisitor = this.newCode = new MethodNode(327680, additionalCode.access, additionalCode.name, additionalCode.desc, additionalCode.signature, additionalCode.exceptions.toArray(new String[0]));
            codeVisitor = ClassWeaver.this.mixinClassVisitor.getWeaveClassInfo().getMethodVisitor(ClassWeaver.this.className, codeVisitor, access, new Method(name, desc));
            additionalCode.accept(codeVisitor);
            this.writer = mv;
        }

        public void visitInsn(int opcode) {
            if (177 == opcode) {
                GeneratorAdapter adapter = new GeneratorAdapter(this.access, this.method, (MethodVisitor)this);
                Label start = adapter.newLabel();
                Label end = adapter.newLabel();
                Label handler = adapter.newLabel();
                adapter.visitLabel(start);
                adapter.visitVarInsn(25, 0);
                adapter.loadArgs();
                adapter.visitMethodInsn(182, ClassWeaver.MAGIC_KEY_FOR_CONSTRUCTOR_INLINE, this.newCode.name, this.method.getDescriptor(), false);
                adapter.goTo(end);
                adapter.visitLabel(handler);
                if (Agent.isDebugEnabled()) {
                    adapter.invokeVirtual(Type.getType(Throwable.class), new Method("printStackTrace", "()V"));
                } else {
                    adapter.pop();
                }
                adapter.visitLabel(end);
                adapter.visitTryCatchBlock(start, end, handler, Type.getType(Throwable.class).getInternalName());
            }
            super.visitInsn(opcode);
        }

        public void visitEnd() {
            this.instructions.resetLabels();
            MethodVisitor mv = this.writer;
            mv = new MethodCallInlinerAdapter(ClassWeaver.this.className, this.access, this.name, this.desc, mv, false){

                protected MethodCallInlinerAdapter.InlinedMethod mustInline(String owner, String name, String desc) {
                    if (ClassWeaver.MAGIC_KEY_FOR_CONSTRUCTOR_INLINE.equals(owner)) {
                        ClassWeaver.this.instrumentationPackage.getLogger().finer("Inline constructor " + name);
                        return new MethodCallInlinerAdapter.InlinedMethod(ConstructorMerger.this.newCode, NO_OP_REMAPPER);
                    }
                    return null;
                }
            };
            this.accept(mv);
        }
    }
}

