/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.weaver.ClassAppender;
import com.newrelic.agent.instrumentation.weaver.InstrumentationMetadata;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.ObjectFieldManagerImpl;
import com.newrelic.agent.instrumentation.weaver.WeaveInstrumentation;
import com.newrelic.agent.instrumentation.weaver.WeavingClassTransformer;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.AgentError;
import com.newrelic.agent.util.asm.BenignClassReadException;
import com.newrelic.bootstrap.BootstrapAgent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWeaverService {
    private final Map<String, InstrumentationPackage> instrumentationPackageNames = Maps.newConcurrentMap();
    private final InstrumentationContextManager contextManager;
    private final Set<InstrumentationPackage> instrumentationPackages = Sets.newCopyOnWriteArraySet();
    private final Set<InstrumentationPackage> internalInstrumentationPackages = Sets.newCopyOnWriteArraySet();

    public ClassWeaverService(InstrumentationContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public InstrumentationContextManager getContextManager() {
        return this.contextManager;
    }

    public InstrumentationPackage getInstrumentationPackage(String implementationTitle) {
        return this.instrumentationPackageNames.get(implementationTitle);
    }

    public void removeInstrumentationPackage(InstrumentationPackage instrumentationPackage) {
        this.instrumentationPackageNames.remove(instrumentationPackage.getImplementationTitle());
        this.contextManager.removeMatchVisitor(instrumentationPackage.getMatcher());
    }

    public void addWeavingClassTransformer(WeavingClassTransformer transformer) {
        this.instrumentationPackageNames.put(transformer.instrumentationPackage.getImplementationTitle(), transformer.instrumentationPackage);
        this.contextManager.addContextClassTransformer(transformer.instrumentationPackage.getMatcher(), transformer);
    }

    public Runnable registerInstrumentation() {
        AgentBridge.objectFieldManager = new ObjectFieldManagerImpl();
        Collection<String> jarFileNames = AgentJarHelper.findAgentJarFileNames(Pattern.compile("instrumentation\\/(.*).jar"));
        if (jarFileNames.isEmpty()) {
            Agent.LOG.error("No instrumentation packages were found in the agent.");
        } else {
            Agent.LOG.fine("Loading " + jarFileNames.size() + " instrumentation packages.");
        }
        this.internalInstrumentationPackages.addAll(this.getInternalInstrumentationPackages(jarFileNames));
        return this.reloadInstrumentationPackages(ServiceFactory.getExtensionService().getWeaveExtensions(), true);
    }

    public Runnable reloadInstrumentationPackages(Collection<File> weaveExtensions) {
        return this.reloadInstrumentationPackages(weaveExtensions, false);
    }

    private Runnable reloadInstrumentationPackages(Collection<File> weaveExtensions, boolean retransformInternalInstrumentationPackageMatches) {
        HashSet<ClassMatchVisitorFactory> unloadedMatchers = Sets.newHashSet();
        final HashSet<InstrumentationPackage> toClose = Sets.newHashSet(this.instrumentationPackages);
        for (InstrumentationPackage ip : this.instrumentationPackages) {
            unloadedMatchers.add(ip.getMatcher());
            this.removeInstrumentationPackage(ip);
        }
        HashSet<ClassMatchVisitorFactory> loadedMatchers = Sets.newHashSet();
        this.instrumentationPackages.clear();
        this.instrumentationPackages.addAll(this.getInstrumentationPackages(weaveExtensions));
        loadedMatchers.addAll(this.buildTransformers(retransformInternalInstrumentationPackageMatches));
        if (!retransformInternalInstrumentationPackageMatches) {
            LinkedList<ClassDefinition> existingClasses = Lists.newLinkedList();
            for (InstrumentationPackage ip : this.instrumentationPackages) {
                Iterator iterator = toClose.iterator();
                while (iterator.hasNext()) {
                    InstrumentationPackage oldIp = (InstrumentationPackage)iterator.next();
                    if (!oldIp.getCloseables().isEmpty() && !oldIp.getImplementationTitle().equals(ip.getImplementationTitle())) continue;
                    iterator.remove();
                }
                for (Map.Entry<String, byte[]> className : ip.newClasses.entrySet()) {
                    try {
                        Class<?> existingClass = this.getClass().getClassLoader().loadClass(className.getKey().replace("/", "."));
                        existingClasses.add(new ClassDefinition(existingClass, className.getValue()));
                    }
                    catch (ClassNotFoundException e) {}
                }
            }
            if (!existingClasses.isEmpty() && ServiceFactory.getAgent().getInstrumentation().isRedefineClassesSupported()) {
                try {
                    ServiceFactory.getAgent().getInstrumentation().redefineClasses(existingClasses.toArray(new ClassDefinition[0]));
                }
                catch (Exception e) {
                    if (!Agent.LOG.isFinestEnabled()) {
                        Agent.LOG.fine("Error redefining classes: " + e.getMessage());
                    }
                    Agent.LOG.log(Level.FINEST, "Error redefining classes", e);
                }
            }
        }
        final HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSet(loadedMatchers);
        matchers.addAll(unloadedMatchers);
        return new Runnable(){

            public void run() {
                ServiceFactory.getClassTransformerService().retransformMatchingClassesImmediately(matchers);
                for (InstrumentationPackage ip : toClose) {
                    for (Closeable closeable : ip.getCloseables()) {
                        try {
                            closeable.close();
                        }
                        catch (IOException e) {
                            Agent.LOG.log(Level.FINE, e, "Error closing InstrumentationPackage {0} closeable {1}", new Object[]{ip.implementationTitle, closeable});
                        }
                    }
                }
            }
        };
    }

    private Collection<ClassMatchVisitorFactory> buildTransformers(boolean retransformInternalInstrumentationPackageMatches) {
        Set<InstrumentationPackage> filteredInstrumentationPackages = this.filter(this.instrumentationPackages, this.internalInstrumentationPackages);
        this.instrumentationPackages.retainAll(filteredInstrumentationPackages);
        if (!retransformInternalInstrumentationPackageMatches) {
            filteredInstrumentationPackages.retainAll(this.instrumentationPackages);
        }
        List<WeavingClassTransformer> transformers = this.createTransformers(filteredInstrumentationPackages);
        for (WeavingClassTransformer transformer : transformers) {
            this.addWeavingClassTransformer(transformer);
            transformer.instrumentationPackage.getLogger().debug("Registered " + transformer.instrumentationPackage.getImplementationTitle());
        }
        HashSet<ClassMatchVisitorFactory> matchers = Sets.newHashSet();
        if (retransformInternalInstrumentationPackageMatches) {
            for (WeavingClassTransformer transformer : transformers) {
                matchers.add(transformer.instrumentationPackage.getMatcher());
            }
        } else {
            for (InstrumentationPackage instrumentationPackage : this.instrumentationPackages) {
                matchers.add(instrumentationPackage.getMatcher());
            }
        }
        return matchers;
    }

    private List<WeavingClassTransformer> createTransformers(Set<InstrumentationPackage> instrumentationPackages) {
        LinkedList<WeavingClassTransformer> transformers = Lists.newLinkedList();
        for (InstrumentationPackage instrumentationPackage : instrumentationPackages) {
            try {
                WeavingClassTransformer transformer = this.getTransformer(instrumentationPackage, instrumentationPackage.getLocation());
                if (transformer == null) continue;
                transformers.add(transformer);
            }
            catch (Exception e) {
                instrumentationPackage.getLogger().severe("Unable to load " + instrumentationPackage.getLocation() + " : " + e.getMessage());
                instrumentationPackage.getLogger().log(Level.FINEST, "Unable to load instrumentation jar " + instrumentationPackage.getLocation(), e);
            }
        }
        return transformers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set<InstrumentationPackage> getInstrumentationPackages(Collection<File> weaveExtensions) {
        HashSet<InstrumentationPackage> instrumentationPackages = Sets.newHashSet();
        for (File file : weaveExtensions) {
            if (!file.exists()) {
                Agent.LOG.error("Unable to find instrumentation jar: " + file.getAbsolutePath());
                continue;
            }
            FileInputStream inputStream = null;
            inputStream = new FileInputStream(file);
            this.addInstrumentationPackage(instrumentationPackages, inputStream, file.getAbsolutePath());
            Object var8_7 = null;
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    Agent.LOG.severe("Unable to open " + file.getAbsolutePath());
                    var8_7 = null;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_7 = null;
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return instrumentationPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set<InstrumentationPackage> getInternalInstrumentationPackages(Collection<String> jarFileNames) {
        HashSet<InstrumentationPackage> instrumentationPackages = Sets.newHashSet();
        for (String name : jarFileNames) {
            URL instrumentationUrl = BootstrapAgent.class.getResource('/' + name);
            if (instrumentationUrl == null) {
                Agent.LOG.error("Unable to find instrumentation jar: " + name);
                continue;
            }
            InputStream inputStream = null;
            inputStream = instrumentationUrl.openStream();
            this.addInstrumentationPackage(instrumentationPackages, inputStream, instrumentationUrl.getFile());
            Object var9_8 = null;
            try {
                inputStream.close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    Agent.LOG.severe("Unable to open " + instrumentationUrl.getFile());
                    var9_8 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return instrumentationPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentationPackage(Set<InstrumentationPackage> instrumentationPackages, InputStream inputStream, String location) {
        IAgentLogger logger = Agent.LOG;
        try {
            try {
                JarInputStream jarStream = new JarInputStream(inputStream);
                InstrumentationMetadata metadata = new InstrumentationMetadata(jarStream, location);
                logger = Agent.LOG.getChildLogger(metadata.getImplementationTitle());
                InstrumentationPackage instrumentationPackage = new InstrumentationPackage(this, logger, metadata, jarStream);
                logger.debug("Loaded " + metadata.getImplementationTitle());
                if (instrumentationPackage.isEnabled()) {
                    instrumentationPackages.add(instrumentationPackage);
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            {
            }
        }
        catch (Exception e) {
            logger.severe("Unable to load " + location + " : " + e.getMessage());
            logger.log(Level.FINEST, "Unable to load instrumentation " + location, e);
        }
        catch (AgentError e) {
            logger.severe("Unable to load " + location + " : " + e.getMessage());
            logger.log(Level.FINEST, "Unable to load instrumentation " + location, e);
        }
    }

    private Set<InstrumentationPackage> filter(Set<InstrumentationPackage> instrumentationPackages, Set<InstrumentationPackage> internalInstrumentationPackages) {
        HashSet<InstrumentationPackage> filteredPackages = Sets.newHashSet();
        filteredPackages.addAll(instrumentationPackages);
        filteredPackages.addAll(internalInstrumentationPackages);
        HashMap<String, InstrumentationPackage> filtered = Maps.newHashMap();
        for (InstrumentationPackage instrumentationPackage : filteredPackages) {
            InstrumentationPackage existing = (InstrumentationPackage)filtered.get(instrumentationPackage.getImplementationTitle());
            if (existing != null) {
                if (existing.getImplementationVersion() == instrumentationPackage.getImplementationVersion()) {
                    Agent.LOG.severe(instrumentationPackage.getLocation() + " is named " + instrumentationPackage.getImplementationTitle() + " which conflicts with the title of " + existing.getLocation());
                    continue;
                }
                if (existing.getImplementationVersion() > instrumentationPackage.getImplementationVersion()) {
                    Agent.LOG.debug(instrumentationPackage.getImplementationTitle() + " v" + instrumentationPackage.getImplementationVersion() + " in " + instrumentationPackage.getLocation() + " is older than version " + existing.getImplementationVersion() + " in " + existing.getLocation());
                    continue;
                }
                filtered.put(instrumentationPackage.getImplementationTitle(), instrumentationPackage);
                continue;
            }
            filtered.put(instrumentationPackage.getImplementationTitle(), instrumentationPackage);
        }
        filteredPackages.retainAll(filtered.values());
        return filteredPackages;
    }

    private WeavingClassTransformer getTransformer(InstrumentationPackage instrumentationPackage, String name) {
        boolean containsJDKClasses = instrumentationPackage.containsJDKClasses();
        return containsJDKClasses ? new BootstrapClassTransformer(instrumentationPackage) : new WeavingClassTransformer(instrumentationPackage);
    }

    public void loadClass(ClassLoader classLoader, String implementationTitle, String className) throws IOException {
        InstrumentationPackage instrumentationPackage = this.getInstrumentationPackage(implementationTitle);
        if (instrumentationPackage != null) {
            String internalClassName = className.replace('.', '/');
            byte[] bytes = instrumentationPackage.getClassBytes().get(internalClassName);
            if (bytes != null) {
                ClassAppender.getSystemClassAppender().appendClasses(classLoader, instrumentationPackage.newClasses);
            } else {
                instrumentationPackage.getLogger().fine("Unable to find " + className + " in instrumentation package " + implementationTitle);
            }
        } else {
            Agent.LOG.log(Level.FINE, "Unable to find instrumentation package {0} for class {1}.", new Object[]{implementationTitle, className});
        }
    }

    public ClassReader getClassReader(Class<?> theClass) throws BenignClassReadException {
        WeaveInstrumentation weaveInstrumentation = theClass.getAnnotation(WeaveInstrumentation.class);
        if (weaveInstrumentation != null) {
            InstrumentationPackage instrumentationPackage = this.instrumentationPackageNames.get(weaveInstrumentation.title());
            byte[] bytes = instrumentationPackage.getClassBytes().get(Type.getInternalName(theClass));
            if (bytes != null) {
                return new ClassReader(bytes);
            }
            throw new BenignClassReadException(theClass.getName() + " is WeaveInstrumentation but could not be found in " + weaveInstrumentation.title());
        }
        return null;
    }

    public void registerInstrumentationCloseable(String instrumentationName, Closeable closeable) {
        InstrumentationPackage instrumentationPackage = this.instrumentationPackageNames.get(instrumentationName);
        if (instrumentationPackage == null) {
            Agent.LOG.log(Level.INFO, "Unable to register closeable {1} for missing instrumentationPackage {0}", new Object[]{instrumentationName, closeable});
            return;
        }
        instrumentationPackage.addCloseable(closeable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BootstrapClassTransformer
    extends WeavingClassTransformer {
        protected BootstrapClassTransformer(InstrumentationPackage instrumentationPackage) {
            super(instrumentationPackage);
        }

        @Override
        protected byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws Exception {
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            return super.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context, match);
        }
    }
}

