/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.ObjectFieldManager;
import com.newrelic.agent.bridge.reflect.ClassReflection;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.instrumentation.InstrumentationImpl;
import com.newrelic.agent.instrumentation.context.CurrentTransactionRewriter;
import com.newrelic.agent.instrumentation.tracing.Annotation;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.tracing.InstrumentationType;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.instrumentation.weaver.IllegalInstructionException;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.instrumentation.weaver.LogApiCallsVisitor;
import com.newrelic.agent.instrumentation.weaver.LogWeavedMethodInvocationsVisitor;
import com.newrelic.agent.instrumentation.weaver.MergeMethodVisitor;
import com.newrelic.agent.instrumentation.weaver.NewClassMarker;
import com.newrelic.agent.instrumentation.weaver.ReflectionHelper;
import com.newrelic.agent.instrumentation.weaver.RegisterClosableInstrumentationVisitor;
import com.newrelic.agent.instrumentation.weaver.WeaveMatchTypeAccessor;
import com.newrelic.agent.instrumentation.weaver.WeaveUtils;
import com.newrelic.agent.instrumentation.weaver.WeavedClassInfo;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.api.agent.Trace;
import com.newrelic.api.agent.weaver.CatchAndLog;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.NewField;
import com.newrelic.api.agent.weaver.SkipIfPresent;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentationClassVisitor
extends ClassVisitor
implements WeavedClassInfo {
    private static final String OBJECT_FIELDS_FIELD_NAME = "objectFieldManager";
    private static final Method INITIALIZE_FIELDS_METHOD = new Method("initializeFields", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Object.class), Type.getType(Object.class)});
    private static final Method GET_FIELD_CONTAINER_METHOD = new Method("getFieldContainer", Type.getType(Object.class), new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private final String className;
    final Set<InnerClassNode> innerClasses = Sets.newHashSet();
    private final Map<String, FieldNode> newFields = Maps.newHashMap();
    private final Map<String, FieldNode> existingFields = Maps.newHashMap();
    private final Set<Method> weavedMethods = Sets.newHashSet();
    private final Set<Method> catchAndLogMethods = Sets.newHashSet();
    private final Map<Method, TraceDetails> tracedMethods = Maps.newHashMap();
    private MethodNode staticConstructor;
    private final Map<Method, MethodNode> constructors = Maps.newHashMap();
    private final WeaveMatchTypeAccessor weaveAnnotation = new WeaveMatchTypeAccessor();
    private final InstrumentationPackage instrumentationPackage;
    private boolean hasNewInstanceField;
    private boolean skipIfPresent;
    private final String superName;

    static InstrumentationClassVisitor getInstrumentationClass(InstrumentationPackage instrumentationPackage, byte[] bytes) {
        ClassReader reader = new ClassReader(bytes);
        InstrumentationClassVisitor cv = new InstrumentationClassVisitor(instrumentationPackage, reader.getClassName(), reader.getSuperName());
        reader.accept(cv, 6);
        return cv;
    }

    private InstrumentationClassVisitor(InstrumentationPackage instrumentationPackage, String className, String superName) {
        super(327680);
        this.className = className;
        this.superName = superName;
        this.instrumentationPackage = instrumentationPackage;
    }

    private String getFieldContainerKeyName(String className) {
        return this.instrumentationPackage.implementationTitle + ':' + className;
    }

    public static String getFieldContainerClassName(String ownerClass) {
        return "weave/newrelic/" + ownerClass + "$NewRelicFields";
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isSkipIfPresent() {
        return this.skipIfPresent;
    }

    @Override
    public MatchType getMatchType() {
        return this.weaveAnnotation.getMatchType();
    }

    public boolean isWeaveInstrumentation() {
        return this.weaveAnnotation.getMatchType() != null;
    }

    private ClassVisitor verifyWeaveConstructors(ClassVisitor cv) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if ("<init>".equals(name) || "<clinit>".equals(name)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            if (BridgeUtils.WEAVER_TYPE.getInternalName().equals(owner)) {
                                throw new IllegalInstructionException("Weave instrumentation constructors must not invoke " + BridgeUtils.WEAVER_TYPE.getClassName() + '.' + WeaveUtils.CALL_ORIGINAL_METHOD);
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    };
                }
                return mv;
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((0x40 & access) == 64) {
            return mv;
        }
        if (this.isWeaveInstrumentation() && "<clinit>".equals(name)) {
            this.staticConstructor = new MethodNode(access, name, desc, signature, exceptions);
            return this.staticConstructor;
        }
        final Method method = new Method(name, desc);
        mv = new TraceAnnotationVisitor(mv, method);
        mv = this.trackCatchAndLogAnnotations(mv, method);
        if ((access & 0x400) != 0) {
            return mv;
        }
        if ("<init>".equals(name)) {
            MethodNode node = new MethodNode(access, name, desc, signature, exceptions);
            mv = node;
            this.constructors.put(method, node);
        }
        return new MethodVisitor(327680, mv){

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (MergeMethodVisitor.isOriginalMethodInvocation(owner, name, desc)) {
                    InstrumentationClassVisitor.this.weavedMethods.add(method);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        };
    }

    private MethodVisitor trackCatchAndLogAnnotations(MethodVisitor mv, final Method method) {
        return new MethodVisitor(327680, mv){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (Type.getDescriptor(CatchAndLog.class).equals(desc)) {
                    InstrumentationClassVisitor.this.catchAndLogMethods.add(method);
                }
                return super.visitAnnotation(desc, visible);
            }
        };
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.isWeaveInstrumentation()) {
            FieldNode field = new FieldNode(327680, access, name, desc, signature, value){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (WeaveUtils.NEW_FIELD_ANNOTATION_DESCRIPTOR.equals(desc)) {
                        InstrumentationClassVisitor.this.newFields.put(this.name, this);
                        if ((this.access & 8) == 0) {
                            InstrumentationClassVisitor.this.hasNewInstanceField = true;
                        }
                    }
                    return super.visitAnnotation(desc, visible);
                }
            };
            if ((access & 0x18) == 24) {
                this.newFields.put(name, field);
            } else {
                this.existingFields.put(name, field);
            }
            return field;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.existingFields.keySet().removeAll(this.newFields.keySet());
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Type.getDescriptor(SkipIfPresent.class).equals(desc)) {
            this.skipIfPresent = true;
        }
        return this.weaveAnnotation.visitAnnotation(desc, visible, super.visitAnnotation(desc, visible));
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.innerClasses.add(new InnerClassNode(name, outerName, innerName, access));
    }

    @Override
    public Set<Method> getWeavedMethods() {
        return Collections.unmodifiableSet(this.weavedMethods);
    }

    @Override
    public Map<Method, TraceDetails> getTracedMethods() {
        return Collections.unmodifiableMap(this.tracedMethods);
    }

    @Override
    public Map<String, FieldNode> getNewFields() {
        return this.newFields;
    }

    @Override
    public Collection<FieldNode> getReferencedFields() {
        return Collections.unmodifiableCollection(this.existingFields.values());
    }

    public void generateInitializeFieldHandlerInstructions(GeneratorAdapter generatorAdapter) {
        if (!this.isWeaveInstrumentation()) {
            return;
        }
        generatorAdapter.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, OBJECT_FIELDS_FIELD_NAME, Type.getType(ObjectFieldManager.class));
        generatorAdapter.push(this.getFieldContainerKeyName(this.className));
        generatorAdapter.loadThis();
        Type fieldContainerType = Type.getObjectType(InstrumentationClassVisitor.getFieldContainerClassName(this.className));
        generatorAdapter.newInstance(fieldContainerType);
        generatorAdapter.dup();
        generatorAdapter.invokeConstructor(fieldContainerType, new Method("<init>", Type.VOID_TYPE, new Type[0]));
        generatorAdapter.invokeInterface(Type.getType(ObjectFieldManager.class), INITIALIZE_FIELDS_METHOD);
    }

    private void generateVisitFieldInstructions(GeneratorAdapter generator, int opcode, String fieldName, String fieldDesc) {
        Type fieldContainerType = Type.getObjectType(InstrumentationClassVisitor.getFieldContainerClassName(this.className));
        Type fieldType = Type.getType(fieldDesc);
        if (opcode == 180) {
            generator.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, OBJECT_FIELDS_FIELD_NAME, Type.getType(ObjectFieldManager.class));
            generator.swap();
            generator.push(this.getFieldContainerKeyName(this.className));
            generator.swap();
            generator.invokeInterface(Type.getType(ObjectFieldManager.class), GET_FIELD_CONTAINER_METHOD);
            this.verifyFieldContainerIsNotNull(generator);
            generator.checkCast(fieldContainerType);
            generator.getField(fieldContainerType, fieldName, fieldType);
        } else if (opcode == 181) {
            int fieldValue = generator.newLocal(fieldType);
            generator.storeLocal(fieldValue);
            generator.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, OBJECT_FIELDS_FIELD_NAME, Type.getType(ObjectFieldManager.class));
            generator.swap();
            generator.push(this.getFieldContainerKeyName(this.className));
            generator.swap();
            generator.invokeInterface(Type.getType(ObjectFieldManager.class), GET_FIELD_CONTAINER_METHOD);
            this.verifyFieldContainerIsNotNull(generator);
            generator.checkCast(fieldContainerType);
            generator.loadLocal(fieldValue);
            generator.putField(fieldContainerType, fieldName, Type.getType(fieldDesc));
        } else if (opcode == 178) {
            generator.getStatic(fieldContainerType, fieldName, fieldType);
        } else if (opcode == 179) {
            generator.putStatic(fieldContainerType, fieldName, Type.getType(fieldDesc));
        }
    }

    private void verifyFieldContainerIsNotNull(GeneratorAdapter generator) {
        generator.dup();
        Label skip = generator.newLabel();
        generator.ifNonNull(skip);
        generator.throwException(Type.getType(NullPointerException.class), "The object field container was null for " + this.getClassName());
        generator.visitLabel(skip);
    }

    @Override
    public MethodVisitor getMethodVisitor(final String className, MethodVisitor codeVisitor, int access, final Method method) {
        if (!this.isWeaveInstrumentation()) {
            return codeVisitor;
        }
        MethodVisitor mv = codeVisitor;
        if (!this.newFields.isEmpty()) {
            mv = new GeneratorAdapter(327680, mv, access, method.getName(), method.getDescriptor()){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    FieldNode fieldNode = (FieldNode)InstrumentationClassVisitor.this.newFields.get(name);
                    if (null != fieldNode) {
                        InstrumentationClassVisitor.this.generateVisitFieldInstructions(this, opcode, name, desc);
                    } else {
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }
                }
            };
        }
        if (!this.existingFields.isEmpty()) {
            mv = new GeneratorAdapter(327680, mv, access, method.getName(), method.getDescriptor()){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    if (className.equals(owner) && !InstrumentationClassVisitor.this.newFields.containsKey(name)) {
                        FieldNode existingField = (FieldNode)InstrumentationClassVisitor.this.existingFields.get(name);
                        if (existingField == null) {
                            throw new IllegalInstructionException("Weaved instrumentation method " + method + " is attempting to access field " + name + " of type " + desc + " which does not exist.  This field may need to be marked with " + NewField.class.getName());
                        }
                        if (!desc.equals(existingField.desc)) {
                            throw new IllegalInstructionException("Weaved instrumentation method " + method + " accesses field " + name + " of type " + desc + ", but the actual type is " + existingField.desc);
                        }
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            };
        }
        return mv;
    }

    @Override
    public MethodVisitor getConstructorMethodVisitor(MethodVisitor mv, String className, int access, String name, String desc) {
        if (this.hasNewInstanceField) {
            mv = new AdviceAdapter(327680, mv, access, name, desc){

                protected void onMethodExit(int opcode) {
                    if (opcode != 191) {
                        Label start = this.newLabel();
                        Label end = this.newLabel();
                        Label handler = this.newLabel();
                        this.visitLabel(start);
                        InstrumentationClassVisitor.this.generateInitializeFieldHandlerInstructions(this);
                        this.goTo(end);
                        this.visitLabel(handler);
                        this.pop();
                        this.visitLabel(end);
                        this.visitTryCatchBlock(start, end, handler, Type.getType(Throwable.class).getInternalName());
                    }
                    super.onMethodExit(opcode);
                }
            };
        }
        return mv;
    }

    public static void performSecondPassProcessing(InstrumentationPackage instrumentationPackage, Map<String, InstrumentationClassVisitor> instrumentationClasses, Map<String, WeavedClassInfo> weaveClasses, Map<String, byte[]> classBytes) {
        for (Map.Entry<String, InstrumentationClassVisitor> entry : instrumentationClasses.entrySet()) {
            byte[] bytes = classBytes.get(entry.getKey());
            ClassReader reader = new ClassReader(bytes);
            ClassWriter writer = new ClassWriter(1);
            ClassVisitor cv = entry.getValue().createSecondPassVisitor(instrumentationPackage, classBytes, weaveClasses, reader, writer);
            reader.accept(cv, 8);
            classBytes.put(entry.getKey(), writer.toByteArray());
        }
    }

    ClassVisitor createSecondPassVisitor(InstrumentationPackage instrumentationPackage, Map<String, byte[]> classBytes, Map<String, WeavedClassInfo> weaveClasses, ClassReader reader, ClassVisitor cv) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && !this.isWeaveInstrumentation()) {
            cv = this.handleElevatePermissions(cv, classBytes);
        }
        cv = new LogApiCallsVisitor(instrumentationPackage, cv);
        cv = new RegisterClosableInstrumentationVisitor(instrumentationPackage, cv);
        cv = InstrumentationClassVisitor.fixInvocationInstructions(weaveClasses, cv);
        cv = InstrumentationClassVisitor.enforceTracedMethodsAccessingTracedMethod(cv, this.getLogger(), this.className, this.tracedMethods.keySet());
        if (this.isWeaveInstrumentation()) {
            if (this.skipIfPresent) {
                // empty if block
            }
            this.createFieldContainerClass(classBytes);
            cv = new LogWeavedMethodInvocationsVisitor(instrumentationPackage, cv);
            cv = InstrumentationClassVisitor.removeTraceAnnotationsFromMethods(cv);
            cv = this.verifyWeaveConstructors(cv);
            cv = InstrumentationClassVisitor.removeDefaultConstructors(this.constructors, cv);
            if (!this.catchAndLogMethods.isEmpty()) {
                this.getLogger().log(Level.SEVERE, "{0} is a weaved class but the following methods are marked with the {1} annotation: {2}", new Object[]{this.className, CatchAndLog.class.getSimpleName(), this.catchAndLogMethods});
            }
        } else {
            this.verifyNewClass();
            cv = NewClassMarker.getVisitor(cv, instrumentationPackage.implementationTitle, Float.toString(instrumentationPackage.implementationVersion));
            cv = CurrentTransactionRewriter.rewriteCurrentTransactionReferences(cv, reader);
            if (!this.catchAndLogMethods.isEmpty()) {
                cv = this.rewriteCatchAndLogMethods(cv);
            }
        }
        return cv;
    }

    private ClassVisitor rewriteCatchAndLogMethods(ClassVisitor cv) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (InstrumentationClassVisitor.this.catchAndLogMethods.contains(new Method(name, desc))) {
                    if (Type.VOID_TYPE.equals(Type.getType(desc).getReturnType())) {
                        mv = InstrumentationClassVisitor.catchAndLogMethodExceptions(InstrumentationClassVisitor.this.instrumentationPackage.getImplementationTitle(), InstrumentationClassVisitor.this.className, access, name, desc, mv);
                    } else {
                        InstrumentationClassVisitor.this.getLogger().log(Level.SEVERE, "{0}.{1}{2} is marked with {3}, but only void return types are supported.", new Object[]{InstrumentationClassVisitor.this.className, name, desc, CatchAndLog.class.getSimpleName()});
                    }
                }
                return mv;
            }
        };
    }

    static AdviceAdapter catchAndLogMethodExceptions(final String instrumentationTitle, final String className, int access, final String name, final String desc, MethodVisitor mv) {
        return new AdviceAdapter(327680, mv, access, name, desc){
            Label start;
            Label end;
            Label handler;
            {
                super(x0, x1, x2, x3, x4);
                this.start = this.newLabel();
                this.end = this.newLabel();
                this.handler = this.newLabel();
            }

            protected void onMethodEnter() {
                super.onMethodEnter();
                this.visitLabel(this.start);
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                super.visitLabel(this.handler);
                final int throwableLocal = this.newLocal(Type.getType(Throwable.class));
                this.storeLocal(throwableLocal);
                Runnable throwableMessage = new Runnable(){

                    public void run() {
                        this.loadLocal(throwableLocal);
                    }
                };
                BridgeUtils.getLogger(this).logToChild(instrumentationTitle, Level.FINE, "{0}.{1}{2} threw an exception: {3}", new Object[]{className, name, desc, throwableMessage});
                BridgeUtils.loadLogger(this);
                this.getStatic(Type.getType(Level.class), Level.FINEST.getName(), Type.getType(Level.class));
                this.loadLocal(throwableLocal);
                this.push("Exception stack:");
                this.visitInsn(1);
                BridgeUtils.getLoggerBuilder(this, false).build().log(Level.FINEST, (Throwable)null, null, new Object[0]);
                this.visitInsn(177);
                super.visitLabel(this.end);
                super.visitTryCatchBlock(this.start, this.end, this.handler, Type.getInternalName(Throwable.class));
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }

    private ClassVisitor handleElevatePermissions(ClassVisitor cv, Map<String, byte[]> classBytes) {
        return new ClassVisitor(327680, cv){
            private final ReflectionHelper reflection;
            {
                this.reflection = ReflectionHelper.get();
            }

            public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                return new GeneratorAdapter(327680, mv, access, methodName, methodDesc){

                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof Type && !InstrumentationClassVisitor.this.getClassName().equals(((Type)cst).getInternalName())) {
                            this.loadClass((Type)cst);
                        } else {
                            super.visitLdcInsn(cst);
                        }
                    }

                    private void loadClass(Type typeToLoad) {
                        super.visitLdcInsn(Type.getObjectType(InstrumentationClassVisitor.this.className));
                        super.invokeStatic(Type.getType(ClassReflection.class), new Method("getClassLoader", "(Ljava/lang/Class;)Ljava/lang/ClassLoader;"));
                        this.push(typeToLoad.getClassName());
                        super.invokeStatic(Type.getType(ClassReflection.class), new Method("loadClass", "(Ljava/lang/ClassLoader;Ljava/lang/String;)Ljava/lang/Class;"));
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        Type objectType = Type.getObjectType(type);
                        if (193 == opcode) {
                            this.loadClass(objectType);
                            super.swap();
                            super.invokeVirtual(Type.getType(Class.class), new Method("isInstance", "(Ljava/lang/Object;)Z"));
                        } else if (192 == opcode) {
                            if (!type.startsWith("java/")) {
                                this.addWeaveClass(objectType);
                            }
                            super.visitTypeInsn(opcode, type);
                        } else {
                            super.visitTypeInsn(opcode, type);
                        }
                    }

                    private void addWeaveClass(Type objectType) {
                        ((InstrumentationImpl)AgentBridge.instrumentation).addWeaveClass(objectType);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (reflection.process(owner, name, desc, this)) {
                            return;
                        }
                        this.addWeaveClass(Type.getObjectType(owner));
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                };
            }
        };
    }

    static ClassVisitor enforceTracedMethodsAccessingTracedMethod(ClassVisitor cv, final IAgentLogger logger, final String className, final Set<Method> tracedMethods) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
                final Method method = new Method(methodName, methodDesc);
                if (!tracedMethods.contains(method)) {
                    mv = new MethodVisitor(327680, mv){

                        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                            super.visitFieldInsn(opcode, owner, name, desc);
                            if (owner.equals(BridgeUtils.TRACED_METHOD_TYPE.getInternalName())) {
                                logger.severe("Error in " + className + '.' + method);
                                throw new IllegalInstructionException(BridgeUtils.TRACED_METHOD_TYPE.getClassName() + '.' + name + " can only be called from a traced method");
                            }
                        }

                        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            if (BridgeUtils.isAgentType(owner) && "getTracedMethod".equals(name)) {
                                logger.severe("Error in " + className + '.' + method);
                                throw new IllegalInstructionException(BridgeUtils.PUBLIC_AGENT_TYPE.getClassName() + '.' + "getTracedMethod" + " can only be called from a traced method");
                            }
                        }
                    };
                }
                return mv;
            }
        };
    }

    static ClassVisitor removeDefaultConstructors(final Map<Method, MethodNode> constructors, ClassVisitor cv) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodNode methodNode = (MethodNode)constructors.get(new Method(name, desc));
                if (this.isDefaultConstructor(methodNode)) {
                    return new MethodVisitor(327680){};
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            private boolean isDefaultConstructor(MethodNode methodNode) {
                return methodNode != null && methodNode.instructions.getLast().getPrevious().getOpcode() == 183;
            }
        };
    }

    void verifyNewClass() throws IllegalInstructionException {
        if (!this.newFields.isEmpty()) {
            this.getLogger().severe("Non-weave class " + this.className + " cannot use @NewField for fields " + this.newFields.keySet());
            throw new IllegalInstructionException(BridgeUtils.WEAVER_TYPE.getClassName() + " is not a weaved method but uses the @NewField annotation");
        }
        if (!this.weavedMethods.isEmpty()) {
            this.getLogger().severe("Error in " + this.className + " methods " + this.weavedMethods);
            throw new IllegalInstructionException(BridgeUtils.WEAVER_TYPE.getClassName() + '.' + WeaveUtils.CALL_ORIGINAL_METHOD + " can only be called from a weaved method");
        }
        if (!this.tracedMethods.isEmpty()) {
            this.getLogger().severe("Error in " + this.className + " methods " + this.tracedMethods.keySet());
            throw new IllegalInstructionException("The Trace annotation can only be used on existing methods in existing classes");
        }
    }

    private static ClassVisitor removeTraceAnnotationsFromMethods(ClassVisitor cv) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (Type.getDescriptor(Trace.class).equals(desc)) {
                            return null;
                        }
                        return super.visitAnnotation(desc, visible);
                    }
                };
            }
        };
    }

    private static ClassVisitor fixInvocationInstructions(final Map<String, WeavedClassInfo> weaveClasses, ClassVisitor cv) {
        return new ClassVisitor(327680, cv){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                mv = new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, mv){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        WeavedClassInfo weaveInfo;
                        if (opcode == 182 && (weaveInfo = (WeavedClassInfo)weaveClasses.get(owner)) != null && MatchType.Interface.equals((Object)weaveInfo.getMatchType())) {
                            itf = true;
                            opcode = 185;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                };
            }
        };
    }

    private void createFieldContainerClass(Map<String, byte[]> classBytes) {
        MethodVisitor mv;
        if (this.newFields.isEmpty()) {
            return;
        }
        final String className = InstrumentationClassVisitor.getFieldContainerClassName(this.className);
        AgentBridge.objectFieldManager.createClassObjectFields(this.getFieldContainerKeyName(this.className));
        ClassWriter cw = new ClassWriter(1);
        cw.visit(49, 33, className, null, "java/lang/Object", new String[0]);
        for (FieldNode field : this.newFields.values()) {
            field.access |= 1;
            field.access &= 0xFFFFFFE9;
            cw.visitField(field.access, field.name, field.desc, field.signature, field.value);
        }
        if (this.staticConstructor != null) {
            mv = cw.visitMethod(9, this.staticConstructor.name, this.staticConstructor.desc, null, null);
            mv = new MethodVisitor(327680, mv){

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    if (owner.equals(InstrumentationClassVisitor.this.className) && InstrumentationClassVisitor.this.newFields.containsKey(name)) {
                        owner = className;
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            };
            this.staticConstructor.instructions.accept(mv);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        this.getLogger().finest("Generated field container " + className);
        classBytes.put(className, cw.toByteArray());
    }

    private IAgentLogger getLogger() {
        return this.instrumentationPackage.getLogger();
    }

    @Override
    public String getSuperName() {
        return this.superName;
    }

    private class TraceAnnotationVisitor
    extends MethodVisitor {
        private final Method method;

        public TraceAnnotationVisitor(MethodVisitor mv, Method method) {
            super(327680, mv);
            this.method = method;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (Type.getDescriptor(Trace.class).equals(desc)) {
                TraceDetailsBuilder builder = TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.WeaveInstrumentation).setInstrumentationSourceName(((InstrumentationClassVisitor)InstrumentationClassVisitor.this).instrumentationPackage.implementationTitle);
                return new Annotation(av, desc, builder){

                    public void visitEnd() {
                        InstrumentationClassVisitor.this.tracedMethods.put(TraceAnnotationVisitor.this.method, this.getTraceDetails(false));
                        super.visitEnd();
                    }
                };
            }
            return av;
        }
    }
}

