/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.RemappingClassAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.SimpleRemapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.instrumentation.classmatchers.ChildClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.DefaultClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.InterfaceMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcherBuilder;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.weaver.ClassAppender;
import com.newrelic.agent.instrumentation.weaver.ClassWeaverService;
import com.newrelic.agent.instrumentation.weaver.InstrumentationClassVisitor;
import com.newrelic.agent.instrumentation.weaver.InstrumentationMetadata;
import com.newrelic.agent.instrumentation.weaver.MergeMethodVisitor;
import com.newrelic.agent.instrumentation.weaver.MixinClassVisitor;
import com.newrelic.agent.instrumentation.weaver.ReferencesVisitor;
import com.newrelic.agent.instrumentation.weaver.Verifier;
import com.newrelic.agent.instrumentation.weaver.WeavedClassInfo;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.BootstrapLoader;
import com.newrelic.agent.util.Streams;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import com.newrelic.agent.util.asm.PatchedClassWriter;
import com.newrelic.api.agent.weaver.MatchType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentationPackage
implements ClassResolver {
    final String implementationTitle;
    private final Verifier verifier;
    private final Map<Method, String> abstractMethods = Maps.newHashMap();
    private final Map<String, byte[]> classNames;
    private final Map<String, WeavedClassInfo> weaveClasses = Maps.newHashMap();
    private final Map<String, WeavedClassInfo> instrumentationInfo = Maps.newHashMap();
    final Map<String, byte[]> newClasses = Maps.newHashMap();
    final Set<String> skipClasses = Sets.newHashSet();
    private final boolean containsBootstrapMergeClasses;
    private final ClassAppender classAppender;
    private final InstrumentationMetadata metaData;
    private final Instrumentation instrumentation;
    private final Collection<Closeable> closeables = new ConcurrentLinkedQueue<Closeable>();
    private OptimizedClassMatcherBuilder matcherBuilder = OptimizedClassMatcherBuilder.newBuilder();
    private final ClassMatchVisitorFactory matcher;
    final float implementationVersion;
    private final String location;
    private final IAgentLogger logger;

    InstrumentationPackage(ClassWeaverService weaverService, IAgentLogger logger, InstrumentationMetadata metaData, JarInputStream jarStream) throws Exception {
        this.location = metaData.getLocation();
        this.instrumentation = weaverService.getContextManager().getInstrumentation();
        HashMap<String, byte[]> classBytes = Maps.newHashMap();
        HashMap<String, InstrumentationClassVisitor> instrumentationClasses = Maps.newHashMap();
        this.implementationTitle = metaData.getImplementationTitle();
        this.metaData = metaData;
        this.logger = logger;
        this.implementationVersion = metaData.getImplementationVersion();
        this.verifier = new Verifier(this);
        JarEntry entry = null;
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (!entry.getName().endsWith(".class")) continue;
            byte[] bytes = Streams.read(jarStream, false);
            InstrumentationClassVisitor instrumentationClass = InstrumentationClassVisitor.getInstrumentationClass(this, bytes);
            instrumentationClasses.put(instrumentationClass.getClassName(), instrumentationClass);
            MatchType matchType = instrumentationClass.getMatchType();
            if (matchType != null) {
                this.weaveClasses.put(instrumentationClass.getClassName(), instrumentationClass);
            }
            this.instrumentationInfo.put(instrumentationClass.getClassName(), instrumentationClass);
            logger.finest("Weave instrumentation class: " + instrumentationClass.getClassName() + ", type: " + (matchType == null ? "NewClass" : matchType));
            classBytes.put(instrumentationClass.getClassName(), bytes);
        }
        if (this.weaveClasses.isEmpty()) {
            logger.finer(this.implementationTitle + " does not contain any weaved classes.");
        }
        InstrumentationClassVisitor.performSecondPassProcessing(this, instrumentationClasses, this.weaveClasses, classBytes);
        this.classNames = ImmutableMap.copyOf(this.performThirdPassProcessing(classBytes, instrumentationClasses));
        this.containsBootstrapMergeClasses = this.isBootstrapClassName(this.weaveClasses.keySet());
        this.classAppender = this.containsBootstrapMergeClasses ? ClassAppender.getBootstrapClassAppender(this.instrumentation) : ClassAppender.getSystemClassAppender();
        this.matcher = this.matcherBuilder.build();
        this.matcherBuilder = null;
    }

    private Map<String, byte[]> performThirdPassProcessing(Map<String, byte[]> classBytes, Map<String, InstrumentationClassVisitor> instrumentationClasses) {
        HashMap<String, String> renamedClasses = Maps.newHashMap();
        for (InstrumentationClassVisitor instrumentationClass : instrumentationClasses.values()) {
            if (!instrumentationClass.isWeaveInstrumentation()) continue;
            for (InnerClassNode innerClass : instrumentationClass.innerClasses) {
                InstrumentationClassVisitor innerClassInfo = instrumentationClasses.get(innerClass.name);
                if (innerClassInfo == null || innerClassInfo.isWeaveInstrumentation()) continue;
                renamedClasses.put(innerClass.name, innerClass.name + "$NR");
            }
        }
        return this.renameClasses(classBytes, renamedClasses, instrumentationClasses);
    }

    private Map<String, byte[]> renameClasses(Map<String, byte[]> classBytes, Map<String, String> classesToRename, Map<String, InstrumentationClassVisitor> instrumentationClasses) {
        HashMap<String, byte[]> actualClassNames = Maps.newHashMap();
        HashMap<String, Set<Method>> referencedClassMethods = Maps.newHashMap();
        HashMap<String, Set<Method>> referencedInterfaceMethods = Maps.newHashMap();
        SimpleRemapper remapper = new SimpleRemapper(classesToRename);
        for (Map.Entry<String, byte[]> entry : classBytes.entrySet()) {
            boolean isWeaveClass;
            ClassWriter writer;
            ClassReader reader = new ClassReader(entry.getValue());
            ClassVisitor cv = writer = new ClassWriter(1);
            WeavedClassInfo instrumentationClass = this.instrumentationInfo.get(reader.getClassName());
            boolean bl = isWeaveClass = instrumentationClass != null && instrumentationClass.getMatchType() != null;
            if (isWeaveClass) {
                cv = new GatherClassMethodMatchers(cv, reader.getClassName(), instrumentationClass);
            }
            cv = new ReferencesVisitor(this.logger, this.getWeavedClassDetails(reader.getClassName()), cv, referencedClassMethods, referencedInterfaceMethods);
            if (!classesToRename.isEmpty()) {
                cv = new RemappingClassAdapter(cv, remapper);
            }
            reader.accept(cv, 8);
            String className = classesToRename.get(entry.getKey());
            if (className == null) {
                className = entry.getKey();
            }
            actualClassNames.put(className, writer.toByteArray());
            if (instrumentationClass != null && instrumentationClass.isSkipIfPresent()) {
                this.skipClasses.add(className);
                continue;
            }
            if (isWeaveClass) continue;
            this.newClasses.put(className, writer.toByteArray());
        }
        this.verifier.setReferences(referencedClassMethods, referencedInterfaceMethods);
        return actualClassNames;
    }

    protected boolean loadClasses(ClassLoader loader, Map<String, URL> resolvedClasses) {
        for (String className : resolvedClasses.keySet()) {
            try {
                loader.loadClass(Type.getObjectType(className).getClassName());
            }
            catch (ClassNotFoundException e) {
                this.logger.log(Level.FINER, "Error loading classes for {0} ({1}) : {2}", new Object[]{this.metaData.getImplementationTitle(), className, e.getMessage()});
                return false;
            }
        }
        return true;
    }

    private boolean isBootstrapClassName(Collection<String> names) {
        BootstrapLoader bootstrapLoader = BootstrapLoader.get();
        for (String name : names) {
            if (!bootstrapLoader.isBootstrapClass(name)) continue;
            return true;
        }
        return false;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public IAgentLogger getLogger() {
        return this.logger;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public float getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getLocation() {
        return this.location;
    }

    static ClassMatcher getClassMatcher(MatchType type, String className) {
        switch (type) {
            case Interface: {
                return new InterfaceMatcher(className);
            }
            case BaseClass: {
                return new ChildClassMatcher(className, false);
            }
        }
        return new ExactClassMatcher(className);
    }

    public void addClassMethodMatcher(ClassAndMethodMatcher classAndMethodMatcher, String className) {
        this.matcherBuilder.addClassMethodMatcher(classAndMethodMatcher);
    }

    public void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    public Collection<Closeable> getCloseables() {
        return Collections.unmodifiableCollection(this.closeables);
    }

    public ClassMatchVisitorFactory getMatcher() {
        return this.matcher;
    }

    public boolean matches(String className) {
        return this.classNames.keySet().contains(className);
    }

    public boolean containsAbstractMatchers() {
        return !this.abstractMethods.isEmpty();
    }

    public boolean isWeaved(String className) {
        return this.weaveClasses.containsKey(className);
    }

    public MixinClassVisitor getMixin(String className) throws IOException {
        WeavedClassInfo weavedClassInfo = this.weaveClasses.get(className);
        if (weavedClassInfo == null) {
            return null;
        }
        byte[] bytes = this.classNames.get(className);
        if (bytes != null) {
            ClassReader classReader = new ClassReader(bytes);
            MixinClassVisitor cv = new MixinClassVisitor(bytes, this, weavedClassInfo);
            classReader.accept(cv, 8);
            if (this.metaData.isDebug()) {
                cv.print();
            }
            return cv;
        }
        return null;
    }

    public Map<String, byte[]> getClassBytes() {
        return this.classNames;
    }

    public boolean containsJDKClasses() {
        for (String className : this.getClassBytes().keySet()) {
            if (!className.startsWith("java/") && !className.startsWith("sun/")) continue;
            return true;
        }
        return false;
    }

    public Set<String> getClassNames() {
        HashSet<String> names = Sets.newHashSet();
        for (String name : this.getClassBytes().keySet()) {
            names.add(Type.getObjectType(name).getClassName());
        }
        return names;
    }

    public ClassAppender getClassAppender() {
        return this.classAppender;
    }

    public String getClassMatch(OptimizedClassMatcher.Match match) {
        for (Collection<String> classNames : match.getClassMatches().values()) {
            for (String className : classNames) {
                if (this.classNames.get(className) == null) continue;
                return className;
            }
        }
        return null;
    }

    private Config getInstrumentationConfig() {
        Object pointCutConfig;
        Map config = Collections.emptyMap();
        if (this.implementationTitle != null && (pointCutConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig().getProperty(this.implementationTitle)) instanceof Map) {
            config = (Map)pointCutConfig;
        }
        return new BaseConfig(config);
    }

    public boolean isEnabled() {
        if (!this.getInstrumentationConfig().getProperty("enabled", this.metaData.isEnabled()).booleanValue()) {
            this.logger.log(Level.INFO, "Disabled instrumentation \"{0}\"", new Object[]{this.implementationTitle});
            return false;
        }
        return true;
    }

    public String toString() {
        return this.implementationTitle + " instrumentation";
    }

    public WeavedClassInfo getWeavedClassDetails(String internalName) {
        return this.weaveClasses.get(internalName);
    }

    public Map<String, WeavedClassInfo> getWeaveClasses() {
        return this.weaveClasses;
    }

    public ClassWriter getClassWriter(int flags, ClassLoader loader) {
        ClassResolver classResolver = ClassResolvers.getMultiResolver(this, ClassResolvers.getClassLoaderResolver(loader));
        return new PatchedClassWriter(2, classResolver);
    }

    @Override
    public InputStream getClassResource(String internalName) throws IOException {
        byte[] bytes = this.newClasses.get(internalName);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public MixinClassVisitor getMixinClassVisitor(String ... matchClassNames) throws IOException {
        for (String matchClassName : matchClassNames) {
            MixinClassVisitor mixin = this.getMixin(matchClassName);
            if (mixin == null) continue;
            return mixin;
        }
        return null;
    }

    private class GatherClassMethodMatchers
    extends ClassVisitor {
        private final List<Method> methods;
        private final String className;
        private final MatchType matchType;
        private final WeavedClassInfo instrumentationClass;

        public GatherClassMethodMatchers(ClassVisitor cv, String className, WeavedClassInfo instrumentationClass) {
            super(327680, cv);
            this.methods = Lists.newArrayList();
            this.className = className;
            this.matchType = instrumentationClass.getMatchType();
            this.instrumentationClass = instrumentationClass;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            final Method method = new Method(name, desc);
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (OptimizedClassMatcher.DEFAULT_CONSTRUCTOR.getName().equals(name) && !OptimizedClassMatcher.DEFAULT_CONSTRUCTOR.getDescriptor().equals(desc)) {
                this.methods.add(method);
                return mv;
            }
            return new MethodVisitor(327680, mv){

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (MergeMethodVisitor.isOriginalMethodInvocation(owner, name, desc)) {
                        GatherClassMethodMatchers.this.methods.add(method);
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            };
        }

        public void visitEnd() {
            super.visitEnd();
            List<Method> methods = this.methods;
            methods.remove(OptimizedClassMatcher.DEFAULT_CONSTRUCTOR);
            if (methods.isEmpty()) {
                if (this.instrumentationClass.getTracedMethods().isEmpty()) {
                    InstrumentationPackage.this.logger.fine(this.className + " is marked as a weaved class, but no methods are matched to be weaved.");
                    return;
                }
                methods = Lists.newArrayList(this.instrumentationClass.getTracedMethods().keySet());
            }
            ClassMatcher classMatcher = InstrumentationPackage.getClassMatcher(this.matchType, this.className);
            for (Method m : methods) {
                if (!this.matchType.isExactMatch()) {
                    InstrumentationPackage.this.abstractMethods.put(m, this.className);
                }
                InstrumentationPackage.this.addClassMethodMatcher(new DefaultClassAndMethodMatcher(classMatcher, new ExactMethodMatcher(m.getName(), m.getDescriptor())), this.className);
            }
        }
    }
}

