/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.weaver.InstrumentationPackage;
import com.newrelic.agent.util.Strings;
import java.util.logging.Level;

public class LogWeavedMethodInvocationsVisitor
extends ClassVisitor {
    private final InstrumentationPackage instrumentationPackage;
    private String className;

    public LogWeavedMethodInvocationsVisitor(InstrumentationPackage instrumentationPackage, ClassVisitor cv) {
        super(327680, cv);
        this.instrumentationPackage = instrumentationPackage;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x400) != 0) {
            return mv;
        }
        if ("<init>".equals(name)) {
            return new BaseLogAdapter(327680, mv, access, name, desc){

                protected void onMethodExit(int opcode) {
                    this.logMethod();
                }
            };
        }
        return new BaseLogAdapter(327680, mv, access, name, desc){

            protected void onMethodEnter() {
                this.logMethod();
            }
        };
    }

    private class BaseLogAdapter
    extends AdviceAdapter {
        private final Method method;

        protected BaseLogAdapter(int api, MethodVisitor mv, int access, String name, String desc) {
            super(api, mv, access, name, desc);
            this.method = new Method(name, desc);
        }

        protected void logMethod() {
            String message = Strings.join(LogWeavedMethodInvocationsVisitor.this.className, ".", this.method.toString(), " invoked");
            BridgeUtils.getLogger(this).logToChild(LogWeavedMethodInvocationsVisitor.this.instrumentationPackage.getImplementationTitle(), Level.FINEST, message, (Object[])null);
        }
    }
}

