/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.create;

import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.create.JmxAttributeFilter;
import com.newrelic.agent.jmx.create.JmxGet;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.stats.StatsEngine;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxSingleMBeanGet
extends JmxGet {
    public JmxSingleMBeanGet(String pObjectName, String rootMetricName, String safeName, Map<JmxType, List<String>> pAttributesToType, Extension origin) throws MalformedObjectNameException {
        super(pObjectName, rootMetricName, safeName, pAttributesToType, origin);
    }

    public JmxSingleMBeanGet(String pObjectName, String safeName, String pRootMetric, List<JmxMetric> pMetrics, JmxAttributeFilter attributeFilter) throws MalformedObjectNameException {
        super(pObjectName, safeName, pRootMetric, pMetrics, attributeFilter);
    }

    @Override
    public void recordStats(StatsEngine statsEngine, Map<ObjectName, Map<String, Float>> resultingMetricToValue, MBeanServer server) {
        for (Map.Entry<ObjectName, Map<String, Float>> currentMBean : resultingMetricToValue.entrySet()) {
            String actualRootMetricName = this.getRootMetricName(currentMBean.getKey(), server);
            if (this.getJmxAttributeFilter() != null && !this.getJmxAttributeFilter().keepMetric(actualRootMetricName)) continue;
            for (JmxMetric current : this.getJmxMetrics()) {
                current.recordSingleMBeanStats(statsEngine, actualRootMetricName, currentMBean.getValue());
            }
        }
    }
}

