/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.messaging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.service.ServiceFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessagingUtil {
    public static void recordParameters(Transaction tx, Map<String, String> requestParameters) {
        if (tx.isIgnore()) {
            return;
        }
        if (!ServiceFactory.getAttributesService().captureMessageParams(tx.getApplicationName())) {
            return;
        }
        if (requestParameters.isEmpty()) {
            return;
        }
        tx.getPrefixedAgentAttributes().put("message.parameters.", MessagingUtil.filterMessageParameters(requestParameters, tx.getAgentConfig().getMaxUserParameterSize()));
    }

    static Map<String, String> filterMessageParameters(Map<String, String> messageParams, int maxSizeLimit) {
        LinkedHashMap<String, String> atts = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> current : messageParams.entrySet()) {
            if (current.getKey().length() > maxSizeLimit) {
                Agent.LOG.log(Level.FINER, "Rejecting request parameter with key \"{0}\" because the key is over the size limit of {1}", new Object[]{current.getKey(), maxSizeLimit});
                continue;
            }
            String value = MessagingUtil.getValue(current.getValue(), maxSizeLimit);
            if (value == null) continue;
            atts.put(current.getKey(), value);
        }
        return atts;
    }

    private static String getValue(String value, int maxSizeLimit) {
        if (value == null || value.length() == 0) {
            return null;
        }
        if (value.length() > maxSizeLimit) {
            value = value.substring(0, maxSizeLimit);
        }
        return value;
    }
}

