/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

final class DefaultPhysicalMemoryProvider {
    private static final String IBM_VENDOR = "IBM";
    private static final String SUN_PHYSICAL_MEMORY_METHOD = "getTotalPhysicalMemorySize";
    private static final String IBM_PHYSICAL_MEMORY_METHOD = "getTotalPhysicalMemory";

    private DefaultPhysicalMemoryProvider() {
        throw new UnsupportedOperationException();
    }

    static Float getPhysicalMemoryInMB() {
        Float result;
        block2: {
            result = null;
            try {
                result = System.getProperty("java.vendor", "unknown").startsWith(IBM_VENDOR) ? DefaultPhysicalMemoryProvider.getPhysicalMemoryMBUsingMethod(IBM_PHYSICAL_MEMORY_METHOD) : DefaultPhysicalMemoryProvider.getPhysicalMemoryMBUsingMethod(SUN_PHYSICAL_MEMORY_METHOD);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINE, "Exception while attempting to get physical memory");
                if (!Agent.LOG.isFinestEnabled()) break block2;
                Agent.LOG.log(Level.FINEST, "Exception while attempting to get physical memory", e);
            }
        }
        return result;
    }

    private static Float getPhysicalMemoryMBUsingMethod(String methodName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Float result = null;
        OperatingSystemMXBean osInfo = ManagementFactory.getOperatingSystemMXBean();
        Method physicalMemMethod = osInfo.getClass().getDeclaredMethod(methodName, new Class[0]);
        physicalMemMethod.setAccessible(true);
        Long phyMem = (Long)physicalMemMethod.invoke((Object)osInfo, new Object[0]);
        if (phyMem != null) {
            result = Float.valueOf((float)phyMem.longValue() / 1048576.0f);
        }
        return result;
    }
}

