/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.platform.AbstractPlatformCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MacPhysicalCoreCountCommand
extends AbstractPlatformCommand<Integer> {
    private static final String[] ARGS = new String[]{"-n", "hw.physicalcpu"};
    private volatile Integer result = null;
    int lineCount = 0;

    MacPhysicalCoreCountCommand() {
        super("/usr/sbin/sysctl", ARGS);
    }

    @Override
    Integer getValue() {
        return this.result;
    }

    @Override
    void processChildLine(String line) {
        if (this.lineCount == 0 && line.trim().matches("[0-9]+")) {
            this.result = Integer.valueOf(line);
        } else {
            Agent.LOG.fine("extra output while getting physical core count");
            this.result = null;
        }
        ++this.lineCount;
    }
}

