/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.platform.AbstractPlatformInspector;
import com.newrelic.agent.platform.AsyncCommandRunner;
import com.newrelic.agent.platform.DefaultPhysicalMemoryProvider;
import com.newrelic.agent.platform.MacPhysicalCoreCountCommand;
import java.io.File;
import java.util.concurrent.ExecutorService;

public class MacPlatformInspector
extends AbstractPlatformInspector {
    static final String COMMAND = "/usr/sbin/sysctl";
    private final AsyncCommandRunner<Integer> coreCountRunner;

    MacPlatformInspector(ExecutorService executor) {
        this.coreCountRunner = new AsyncCommandRunner<Integer>(new MacPhysicalCoreCountCommand(), executor);
    }

    boolean recognizesPlatform() {
        return new File(COMMAND).exists();
    }

    void start(AgentConfig config) {
        this.coreCountRunner.start();
    }

    boolean isDone() {
        return this.coreCountRunner.isDone();
    }

    Integer getPhysicalCoreCount() {
        return this.coreCountRunner.getCommand().getValue();
    }

    Float getPhysicalMemoryInMB() {
        return DefaultPhysicalMemoryProvider.getPhysicalMemoryInMB();
    }
}

