/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.platform;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ThreadService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class UnregisteredThreadFactory
implements ThreadFactory {
    private final String baseName;
    private final boolean daemon;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public UnregisteredThreadFactory(String baseName, boolean daemon) {
        this.baseName = baseName;
        this.daemon = daemon;
    }

    public Thread newThread(Runnable r) {
        int num = this.threadNumber.getAndIncrement();
        String threadName = num == 1 ? this.baseName : this.baseName + " " + num;
        UnregisteredThreadImpl t = new UnregisteredThreadImpl(r, threadName);
        Agent.LOG.fine("Created agent thread: " + t.getName());
        if (this.daemon) {
            t.setDaemon(true);
        }
        return t;
    }

    private static class UnregisteredThreadImpl
    extends Thread
    implements ThreadService.AgentThread {
        public UnregisteredThreadImpl(Runnable r, String threadName) {
            super(r, threadName);
        }
    }
}

