/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.profile.ProfilingTask;
import com.newrelic.agent.profile.ProfilingTaskController;
import com.newrelic.agent.profile.XrayClockTimeController;
import com.newrelic.agent.profile.XrayCpuTimeController;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class ProfilingTaskControllerFactory {
    public static ProfilingTaskController createProfilingTaskController(ProfilingTask profilingTask) {
        if (ProfilingTaskControllerFactory.isThreadCpuTimeSupportedAndEnabled()) {
            return new XrayCpuTimeController(profilingTask);
        }
        return new XrayClockTimeController(profilingTask);
    }

    private static boolean isThreadCpuTimeSupportedAndEnabled() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled();
    }
}

