/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MethodInfoUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleMethodInfo
extends MethodInfo {
    private final Set<Member> possibleMethods;

    public MultipleMethodInfo(Set<Member> methods) {
        this.possibleMethods = methods;
    }

    @Override
    public List<Map<String, Object>> getJsonMethodMaps() {
        ArrayList<Map<String, Object>> methodList = Lists.newArrayList();
        for (Member current : this.possibleMethods) {
            HashMap<String, Object> oneMethod = Maps.newHashMap();
            MultipleMethodInfo.addOneMethodArgs(oneMethod, MethodInfoUtil.getArguments(current));
            MultipleMethodInfo.addOneMethodInstrumentedInfo(oneMethod, ((AnnotatedElement)((Object)current)).getAnnotation(InstrumentedMethod.class));
            methodList.add(oneMethod);
        }
        return methodList;
    }
}

