/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.util.TimeConversion;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.logging.Level;

public abstract class AbstractCPUSampler {
    private double lastCPUTimeSeconds;
    private long lastTimestampNanos;
    private final int processorCount = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();

    protected AbstractCPUSampler() {
        Agent.LOG.finer(this.processorCount + " processor(s)");
    }

    protected abstract double getProcessCpuTime();

    protected void recordCPU(StatsEngine statsEngine) {
        String msg;
        double currentProcessTime = this.getProcessCpuTime();
        double dCPU = currentProcessTime - this.lastCPUTimeSeconds;
        this.lastCPUTimeSeconds = currentProcessTime;
        long now = System.nanoTime();
        long elapsedNanos = now - this.lastTimestampNanos;
        this.lastTimestampNanos = now;
        double elapsedTime = TimeConversion.convertNanosToSeconds(elapsedNanos);
        double utilization = dCPU / (elapsedTime * (double)this.processorCount);
        boolean shouldLog = Agent.LOG.isLoggable(Level.FINER);
        if (shouldLog) {
            msg = MessageFormat.format("Recorded CPU time: {0} ({1}) {2}", dCPU, utilization, this.getClass().getName());
            Agent.LOG.finer(msg);
        }
        if (this.lastCPUTimeSeconds > 0.0 && dCPU >= 0.0) {
            if (Double.isNaN(dCPU) || Double.isInfinite(dCPU)) {
                if (shouldLog) {
                    msg = MessageFormat.format("Infinite or non-number CPU time: {0} (current) - {1} (last)", currentProcessTime, this.lastCPUTimeSeconds);
                    Agent.LOG.finer(msg);
                }
            } else {
                statsEngine.getStats("CPU/User Time").recordDataPoint((float)dCPU);
            }
            if (Double.isNaN(utilization) || Double.isInfinite(utilization)) {
                if (shouldLog) {
                    msg = MessageFormat.format("Infinite or non-number CPU utilization: {0} ({1})", utilization, dCPU);
                    Agent.LOG.finer(msg);
                }
            } else {
                statsEngine.getStats("CPU/User/Utilization").recordDataPoint((float)utilization);
            }
        } else if (shouldLog) {
            msg = MessageFormat.format("Bad CPU time: {0} (current) - {1} (last)", currentProcessTime, this.lastCPUTimeSeconds);
            Agent.LOG.finer(msg);
        }
    }
}

