/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.instrumentation.pointcuts.database.SqlStatementTracer;
import com.newrelic.agent.sql.SqlTracerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSqlTracerListener
implements SqlTracerListener {
    private final Object lock = new Object();
    private final double thresholdInMillis;
    private volatile List<SqlStatementTracer> sqlTracers = null;

    public DefaultSqlTracerListener(double thresholdInMillis) {
        this.thresholdInMillis = thresholdInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noticeSqlTracer(SqlStatementTracer sqlTracer) {
        if ((double)sqlTracer.getDurationInMilliseconds() > this.thresholdInMillis) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sqlTracers == null) {
                    this.sqlTracers = new ArrayList<SqlStatementTracer>();
                }
                this.sqlTracers.add(sqlTracer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlStatementTracer> getSqlTracers() {
        if (this.sqlTracers == null) {
            return Collections.emptyList();
        }
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<SqlStatementTracer>(this.sqlTracers);
        }
    }
}

