/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.Agent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.StatsServiceMetricAggregator;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.api.agent.MetricAggregator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StatsServiceImpl
extends AbstractService
implements StatsService {
    private final MetricAggregator metricAggregator = new StatsServiceMetricAggregator(this);
    private final ConcurrentMap<String, StatsEngineQueue> statsEngineQueues = new ConcurrentHashMap<String, StatsEngineQueue>();
    private volatile StatsEngineQueue defaultStatsEngineQueue;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public StatsServiceImpl() {
        super(StatsService.class.getSimpleName());
        this.defaultStatsEngineQueue = this.createStatsEngineQueue();
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void doStatsWork(StatsWork work) {
        String appName = work.getAppName();
        boolean done = false;
        while (!done) {
            done = this.getOrCreateStatsEngineQueue(appName).doStatsWork(work);
        }
    }

    public StatsEngine getStatsEngineForHarvest(String appName) {
        StatsEngineQueue oldStatsEngineQueue = this.replaceStatsEngineQueue(appName);
        oldStatsEngineQueue.close();
        return oldStatsEngineQueue.getStatsEngineForHarvest();
    }

    public MetricAggregator getMetricAggregator() {
        return this.metricAggregator;
    }

    private StatsEngineQueue replaceStatsEngineQueue(String appName) {
        StatsEngineQueue oldStatsEngineQueue = this.getOrCreateStatsEngineQueue(appName);
        StatsEngineQueue newStatsEngineQueue = this.createStatsEngineQueue();
        if (oldStatsEngineQueue == this.defaultStatsEngineQueue) {
            this.defaultStatsEngineQueue = newStatsEngineQueue;
        } else {
            this.statsEngineQueues.put(appName, newStatsEngineQueue);
        }
        return oldStatsEngineQueue;
    }

    private StatsEngineQueue getOrCreateStatsEngineQueue(String appName) {
        StatsEngineQueue statsEngineQueue = this.getStatsEngineQueue(appName);
        if (statsEngineQueue != null) {
            return statsEngineQueue;
        }
        statsEngineQueue = this.createStatsEngineQueue();
        StatsEngineQueue oldStatsEngineQueue = this.statsEngineQueues.putIfAbsent(appName, statsEngineQueue);
        return oldStatsEngineQueue == null ? statsEngineQueue : oldStatsEngineQueue;
    }

    private StatsEngineQueue getStatsEngineQueue(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultStatsEngineQueue;
        }
        return (StatsEngineQueue)this.statsEngineQueues.get(appName);
    }

    private StatsEngineQueue createStatsEngineQueue() {
        return new StatsEngineQueue();
    }

    private static class StatsEngineQueue {
        private volatile boolean isClosed = false;
        private final BlockingQueue<StatsEngine> statsEngineQueue = new LinkedBlockingQueue<StatsEngine>();
        private final Lock readLock;
        private final Lock writeLock;
        private final AtomicInteger statsEngineCount = new AtomicInteger();

        private StatsEngineQueue() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean doStatsWork(StatsWork work) {
            if (this.readLock.tryLock()) {
                block4: {
                    try {
                        if (!this.isClosed()) break block4;
                        boolean bl = false;
                        Object var4_4 = null;
                        this.readLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        this.readLock.unlock();
                        throw throwable;
                    }
                }
                this.doStatsWorkUnderLock(work);
                boolean bl = true;
                Object var4_5 = null;
                this.readLock.unlock();
                return bl;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void doStatsWorkUnderLock(StatsWork work) {
            block13: {
                StatsEngine statsEngine = null;
                statsEngine = (StatsEngine)this.statsEngineQueue.poll();
                if (statsEngine == null) {
                    statsEngine = this.createStatsEngine();
                    this.statsEngineCount.incrementAndGet();
                }
                work.doWork(statsEngine);
                Object var6_3 = null;
                if (statsEngine == null) break block13;
                try {
                    if (!this.statsEngineQueue.offer(statsEngine)) {
                        Agent.LOG.warning("Failed to return stats engine to queue");
                    }
                    break block13;
                }
                catch (Exception e2) {
                    String msg2 = MessageFormat.format("Exception returning stats engine to queue: {0}", e2);
                    Agent.LOG.warning(msg2);
                }
                break block13;
                {
                    catch (Exception e) {
                        String msg = MessageFormat.format("Exception doing stats work: {0}", e);
                        Agent.LOG.warning(msg);
                        Object var6_4 = null;
                        if (statsEngine == null) break block13;
                        try {
                            if (!this.statsEngineQueue.offer(statsEngine)) {
                                Agent.LOG.warning("Failed to return stats engine to queue");
                            }
                            break block13;
                        }
                        catch (Exception e2) {
                            String msg2 = MessageFormat.format("Exception returning stats engine to queue: {0}", e2);
                            Agent.LOG.warning(msg2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    if (statsEngine != null) {
                        try {
                            if (!this.statsEngineQueue.offer(statsEngine)) {
                                Agent.LOG.warning("Failed to return stats engine to queue");
                            }
                        }
                        catch (Exception e2) {
                            String msg2 = MessageFormat.format("Exception returning stats engine to queue: {0}", e2);
                            Agent.LOG.warning(msg2);
                        }
                    }
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatsEngine getStatsEngineForHarvest() {
            this.writeLock.lock();
            try {
                StatsEngine statsEngine = this.getStatsEngineForHarvestUnderLock();
                Object var3_2 = null;
                this.writeLock.unlock();
                return statsEngine;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }

        private StatsEngine getStatsEngineForHarvestUnderLock() {
            ArrayList statsEngines = new ArrayList();
            try {
                this.statsEngineQueue.drainTo(statsEngines);
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Exception draining stats engine queue: {0}", e);
                Agent.LOG.warning(msg);
            }
            if (statsEngines.size() != this.statsEngineCount.get()) {
                String msg = MessageFormat.format("Error draining stats engine queue. Expected: {0} actual: {1}", this.statsEngineCount.get(), statsEngines.size());
                Agent.LOG.warning(msg);
            }
            StatsEngine harvestStatsEngine = this.createStatsEngine();
            for (StatsEngine statsEngine : statsEngines) {
                harvestStatsEngine.mergeStats(statsEngine);
            }
            return harvestStatsEngine;
        }

        private StatsEngine createStatsEngine() {
            return new StatsEngineImpl();
        }

        public void close() {
            this.isClosed = true;
        }

        private boolean isClosed() {
            return this.isClosed;
        }
    }
}

