/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.SqlObfuscator;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ISqlStatementTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.StackTraces;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionSegment
implements JSONStreamAware {
    private static final String PARTIAL_TRACE = "partialtrace";
    private static final Pattern INSERT_INTO_VALUES_STATEMENT = Pattern.compile("\\s*insert\\s+into\\s+([^\\s(,]*)\\s+values.*", 2);
    private static final String URI_PARAM_NAME = "uri";
    private String metricName;
    private final List<TransactionSegment> children;
    private final long entryTimestamp;
    private long exitTimestamp;
    private final Map<String, Object> tracerParameters;
    private int callCount = 1;
    private final String uri;
    private final SqlObfuscator sqlObfuscator;
    private final TransactionTracerConfig ttConfig;
    private final List<StackTraceElement> parentStackTrace;
    private final ClassMethodSignature classMethodSignature;

    public TransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer) {
        this(ttConfig, sqlObfuscator, startTime, tracer, null);
    }

    TransactionSegment(TransactionTracerConfig ttConfig, SqlObfuscator sqlObfuscator, long startTime, Tracer tracer, TransactionSegment childSegment) {
        this.ttConfig = ttConfig;
        this.sqlObfuscator = sqlObfuscator;
        this.metricName = TransactionSegment.getMetricName(tracer);
        this.uri = TransactionSegment.getUri(tracer);
        if (childSegment == null) {
            this.children = Lists.newArrayList();
        } else {
            this.children = new ArrayList<TransactionSegment>(1);
            this.children.add(childSegment);
        }
        this.entryTimestamp = tracer.getStartTimeInMilliseconds() - startTime;
        this.exitTimestamp = tracer.getEndTimeInMilliseconds() - startTime;
        this.tracerParameters = this.getParameters(tracer);
        this.classMethodSignature = tracer.getClassMethodSignature();
        this.parentStackTrace = this.getParentStackTrace(tracer);
    }

    private List<StackTraceElement> getParentStackTrace(Tracer tracer) {
        Map<String, Object> parameters;
        if (tracer.getParentTracer() != null && (parameters = tracer.getParentTracer().getParameters()) != null) {
            return (List)parameters.get("backtrace");
        }
        return null;
    }

    private Map<String, Object> getParameters(Tracer tracer) {
        Object sql;
        Map<String, Object> parameters = tracer.getParameters();
        if (tracer instanceof ISqlStatementTracer && (sql = ((ISqlStatementTracer)((Object)tracer)).getSql()) != null) {
            parameters.put("sql", sql);
        }
        return parameters;
    }

    private static String getMetricName(Tracer tracer) {
        String metricName = tracer.getTransactionSegmentName();
        if (metricName == null || metricName.trim().length() == 0) {
            if (Agent.isDebugEnabled()) {
                throw new RuntimeException(MessageFormat.format("Encountered a transaction segment with an invalid metric name. {0}", tracer.getClass().getName()));
            }
            metricName = tracer.getClass().getName() + "*";
        }
        return metricName;
    }

    public Map<String, Object> getTraceParameters() {
        return Collections.unmodifiableMap(this.tracerParameters);
    }

    private static String getUri(Tracer tracer) {
        return tracer.getTransactionSegmentUri();
    }

    void setMetricName(String name) {
        this.metricName = name;
    }

    public Collection<TransactionSegment> getChildren() {
        return Collections.unmodifiableCollection(this.children);
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void addChild(TransactionSegment sample) {
        try {
            this.children.add(sample);
        }
        catch (UnsupportedOperationException e) {
            String msg = MessageFormat.format("Unable to add transaction segment {0} to parent segment {1}", sample, this);
            Agent.LOG.info(msg);
        }
    }

    public String toString() {
        return this.metricName;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(this.tracerParameters);
        this.processStackTraces(params);
        this.processSqlParams(params);
        if (this.callCount > 1) {
            params.put("call_count", this.callCount);
        }
        if (this.uri != null && this.uri.length() > 0) {
            params.put(URI_PARAM_NAME, this.uri);
        }
        JSONArray.writeJSONString(Arrays.asList(this.entryTimestamp, this.exitTimestamp, this.metricName, params, this.children, this.classMethodSignature.getClassName(), this.classMethodSignature.getMethodName()), writer);
    }

    private void processSqlParams(Map<String, Object> params) {
        Object sqlObj = params.remove("sql");
        if (sqlObj == null) {
            return;
        }
        String sql = this.sqlObfuscator.obfuscateSql(sqlObj.toString());
        if (sql == null) {
            return;
        }
        if (INSERT_INTO_VALUES_STATEMENT.matcher(sql).matches()) {
            int maxLength = this.ttConfig.getInsertSqlMaxLength();
            sql = TransactionSegment.truncateSql(sql, maxLength);
        }
        if (this.ttConfig.isLogSql()) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("{0} SQL: {1}", this.ttConfig.getRecordSql(), sql));
            return;
        }
        params.put(this.sqlObfuscator.isObfuscating() ? "sql_obfuscated" : "sql", sql);
    }

    private void processStackTraces(Map<String, Object> params) {
        List backtrace = (List)params.remove("backtrace");
        if (backtrace != null) {
            List<StackTraceElement> preStackTraces = StackTraces.scrubAndTruncate(backtrace);
            List<String> postParentRemovalTrace = StackTraces.toStringListRemoveParent(preStackTraces, this.parentStackTrace);
            if (preStackTraces.size() == postParentRemovalTrace.size()) {
                params.put("backtrace", postParentRemovalTrace);
            } else {
                params.put(PARTIAL_TRACE, postParentRemovalTrace);
            }
        }
    }

    public void merge(Tracer tracer) {
        ++this.callCount;
        this.exitTimestamp += tracer.getDurationInMilliseconds();
    }

    public static String truncateSql(String sql, int maxLength) {
        int len = sql.length();
        if (len > maxLength) {
            return MessageFormat.format("{0}..({1} more chars)", sql.substring(0, maxLength), len - maxLength);
        }
        return sql;
    }
}

