/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.trace;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.ITransactionSampler;
import com.newrelic.agent.trace.TransactionTrace;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTraceBucket
implements ITransactionSampler {
    private static final int NO_TRACE_LIMIT = 5;
    private volatile Map<String, Long> tracedTransactions;
    private final AtomicReference<TransactionData> expensiveTransaction = new AtomicReference();
    private volatile long maxDurationInNanos;
    private final int topN = ServiceFactory.getConfigService().getDefaultAgentConfig().getTransactionTracerConfig().getTopN();
    private int noTraceCount;
    private final Lock readLock;
    private final Lock writeLock;

    public TransactionTraceBucket() {
        this.tracedTransactions = Collections.unmodifiableMap(new HashMap(this.topN));
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noticeTransaction(TransactionData td) {
        if (td.getDuration() <= td.getTransactionTracerConfig().getTransactionThresholdInNanos()) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Transaction trace threshold not exceeded {0}", td);
                Agent.LOG.finer(msg);
            }
            return false;
        }
        if (td.getDuration() <= this.maxDurationInNanos) {
            return false;
        }
        this.readLock.lock();
        try {
            boolean bl = this.noticeTransactionUnderLock(td);
            Object var4_4 = null;
            this.readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    private boolean noticeTransactionUnderLock(TransactionData td) {
        TransactionData current;
        Long lastDuration = this.tracedTransactions.get(td.getBlameMetricName());
        if (lastDuration != null && td.getDuration() <= lastDuration) {
            return false;
        }
        do {
            if ((current = this.expensiveTransaction.get()) == null || current.getDuration() < td.getDuration()) continue;
            return false;
        } while (!this.expensiveTransaction.compareAndSet(current, td));
        this.maxDurationInNanos = td.getDuration();
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Captured expensive transaction trace for {0} {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TransactionTrace> harvest(String appName) {
        TransactionData td = null;
        this.writeLock.lock();
        try {
            td = this.harvestUnderLock(appName);
            Object var4_3 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        if (td == null) {
            return Collections.emptyList();
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Sending transaction trace for {0} {1}", td.getApplicationName(), td);
            Agent.LOG.finer(msg);
        }
        TransactionTrace trace = TransactionTrace.getTransactionTrace(td);
        ArrayList<TransactionTrace> traces = new ArrayList<TransactionTrace>(1);
        traces.add(trace);
        return traces;
    }

    private TransactionData harvestUnderLock(String appName) {
        this.maxDurationInNanos = 0L;
        TransactionData td = this.expensiveTransaction.getAndSet(null);
        this.noticeTracedTransaction(td);
        return td;
    }

    private void noticeTracedTransaction(TransactionData td) {
        if (this.topN == 0) {
            return;
        }
        int size = this.tracedTransactions.size();
        if (td == null) {
            ++this.noTraceCount;
            if (this.noTraceCount >= 5 && size > 0) {
                this.noTraceCount = 0;
                this.tracedTransactions = Collections.unmodifiableMap(new HashMap(this.topN));
            }
            return;
        }
        this.noTraceCount = 0;
        HashMap<String, Long> ttMap = new HashMap<String, Long>(this.topN);
        if (size < this.topN) {
            ttMap.putAll(this.tracedTransactions);
        }
        ttMap.put(td.getBlameMetricName(), td.getDuration());
        this.tracedTransactions = Collections.unmodifiableMap(ttMap);
    }

    @Override
    public void stop() {
        this.expensiveTransaction.set(null);
        this.tracedTransactions.clear();
    }

    @Override
    public long getMaxDurationInNanos() {
        return this.maxDurationInNanos;
    }
}

