/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.RetryException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.util.Strings;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTracer
implements Tracer,
ExitTracer {
    private final TransactionActivity transactionActivity;
    private Set<String> rollupMetricNames;

    public AbstractTracer(Transaction transaction) {
        this(transaction, transaction == null ? null : transaction.getTransactionActivity());
    }

    public AbstractTracer(Transaction tx, TransactionActivity txa) {
        this.transactionActivity = txa;
    }

    public final Transaction getTransaction() {
        return this.transactionActivity.getTransaction();
    }

    public final TransactionActivity getTransactionActivity() {
        return this.transactionActivity;
    }

    protected Object getInvocationTarget() {
        return null;
    }

    @Override
    public final Object invoke(Object methodName, Method method, Object[] args) {
        block14: {
            try {
                if (args == null) {
                    Agent.LOG.severe("Tracer.finish() was invoked with no arguments");
                } else if ("s" == methodName) {
                    if (args.length == 2) {
                        this.finish((Integer)args[0], args[1]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(int, Object) was invoked with {0} arguments(s)", args.length));
                    }
                } else if ("u" == methodName) {
                    if (args.length == 1) {
                        this.finish((Throwable)args[0]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(Throwable) was invoked with {0} arguments(s)", args.length));
                    }
                } else {
                    Agent.LOG.severe(MessageFormat.format("Tracer.finish was invoked with an unknown method: {0}", methodName));
                }
            }
            catch (RetryException e) {
                return this.invoke(methodName, method, args);
            }
            catch (Throwable t) {
                if (!Agent.LOG.isLoggable(Level.FINE)) break block14;
                String msg = MessageFormat.format("An error occurred finishing method tracer {0} for signature {1} : {2}", this.getClass().getName(), this.getClassMethodSignature(), t.toString());
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, t);
                }
                Agent.LOG.fine(msg);
            }
        }
        return null;
    }

    @Override
    public abstract ClassMethodSignature getClassMethodSignature();

    @Override
    public boolean isChildHasStackTrace() {
        return false;
    }

    public void nameTransaction(TransactionNamePriority priority) {
        try {
            ClassMethodSignature classMethodSignature = this.getClassMethodSignature();
            Object invocationTarget = this.getInvocationTarget();
            String className = invocationTarget == null ? classMethodSignature.getClassName() : invocationTarget.getClass().getName();
            String txName = "/Custom/" + className + '/' + classMethodSignature.getMethodName();
            Agent.LOG.log(Level.FINER, "Setting transaction name using instrumented class and method: {0}", new Object[]{txName});
            Transaction tx = this.transactionActivity.getTransaction();
            tx.setPriorityTransactionName(PriorityTransactionName.create(tx, txName, "Custom", priority));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TracedMethod getParentTracedMethod() {
        return this.getParentTracer();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    protected Set<String> getRollupMetricNames() {
        return this.rollupMetricNames;
    }

    public void addRollupMetricName(String ... metricNameParts) {
        if (this.rollupMetricNames == null) {
            this.rollupMetricNames = new HashSet<String>();
        }
        this.rollupMetricNames.add(Strings.join('/', metricNameParts));
    }

    public void setRollupMetricNames(String ... metricNames) {
        this.rollupMetricNames = new HashSet<String>(metricNames.length);
        for (String metricName : metricNames) {
            this.rollupMetricNames.add(metricName);
        }
    }
}

