/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.agent.util.Strings;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class CrossProcessNameFormat
implements MetricNameFormat {
    private final String transactionName;
    private final String crossProcessId;
    private final String hostName;
    private final String uri;
    private final String transactionId;

    private CrossProcessNameFormat(String transactionName, String crossProcessId, String hostName, String uri, String transactionId) {
        this.hostName = hostName;
        this.crossProcessId = crossProcessId;
        this.transactionName = transactionName;
        this.uri = uri;
        this.transactionId = transactionId;
    }

    public String getHostCrossProcessIdRollupMetricName() {
        return Strings.join('/', "ExternalApp", this.hostName, this.crossProcessId, "all");
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("host:").append(this.hostName).append(" crossProcessId:").append(this.crossProcessId).append(" transactionName:").append(this.transactionName).append(" uri:").append(this.uri).append(" transactionId:").append(this.transactionId);
        return sb.toString();
    }

    public String getMetricName() {
        return Strings.join('/', "ExternalTransaction", this.hostName, this.crossProcessId, this.transactionName);
    }

    public String getTransactionSegmentName() {
        return this.getMetricName();
    }

    public String getTransactionSegmentUri() {
        return this.uri;
    }

    public static CrossProcessNameFormat create(String host, String uri, String encodedAppData, String encodingKey) {
        String msg;
        if (encodedAppData == null) {
            return null;
        }
        if (encodingKey == null) {
            return null;
        }
        if (host == null || host.length() == 0) {
            return null;
        }
        String appData = null;
        try {
            appData = Obfuscator.deobfuscateNameUsingKey(encodedAppData, encodingKey);
        }
        catch (UnsupportedEncodingException ex) {
            msg = MessageFormat.format("Error decoding application data {0}: {1}", encodedAppData, ex);
            Agent.LOG.error(msg);
        }
        if (appData == null) {
            return null;
        }
        try {
            JSONParser parser = new JSONParser();
            JSONArray arr = (JSONArray)parser.parse(appData);
            String crossProcessId = (String)arr.get(0);
            String transactionName = (String)arr.get(1);
            String transactionId = null;
            if (arr.size() > 5) {
                transactionId = (String)arr.get(5);
            }
            return new CrossProcessNameFormat(transactionName, crossProcessId, host, uri, transactionId);
        }
        catch (ParseException ex) {
            if (Agent.LOG.isFinerEnabled()) {
                msg = MessageFormat.format("Unable to parse application data {0}: {1}", appData, ex);
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }
}

