/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.OtherDispatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.tracers.metricname.ClassMethodMetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;

public class OtherRootTracer
extends DefaultTracer
implements TransactionActivityInitiator {
    private final MetricNameFormat uri;

    public OtherRootTracer(Transaction transaction, ClassMethodSignature sig, Object object, MetricNameFormat uri) {
        super(transaction, sig, object, new ClassMethodMetricNameFormat(sig, object));
        this.uri = uri;
    }

    public Dispatcher createDispatcher() {
        return new OtherDispatcher(this.getTransaction(), this.uri);
    }

    protected void doFinish(Throwable throwable) {
        super.doFinish(throwable);
        if (this.equals(this.getTransaction().getTransactionActivity().getRootTracer())) {
            this.getTransaction().setThrowable(throwable);
        }
    }
}

