/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.deps.com.google.common.cache.Cache;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.instrumentation.pointcuts.database.ConnectionFactory;
import java.sql.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCache {
    private static final int MAX_CONN_CACHE_SIZE = 50;
    private Cache<Connection, ConnectionFactory> connectionFactoryCache;

    public void putConnectionFactory(Connection key, ConnectionFactory val) {
        this.getOrCreateConnectionFactoryCache().put(key, val);
    }

    public long getConnectionFactoryCacheSize() {
        return this.getOrCreateConnectionFactoryCache().size();
    }

    public ConnectionFactory removeConnectionFactory(Connection key) {
        if (this.connectionFactoryCache == null) {
            return null;
        }
        ConnectionFactory cf = this.connectionFactoryCache.getIfPresent(key);
        this.connectionFactoryCache.invalidate(key);
        return cf;
    }

    public Cache<Connection, ConnectionFactory> getConnectionFactoryCache() {
        return this.connectionFactoryCache;
    }

    private Cache<Connection, ConnectionFactory> getOrCreateConnectionFactoryCache() {
        if (this.connectionFactoryCache == null) {
            this.connectionFactoryCache = CacheBuilder.newBuilder().maximumSize(50L).build();
        }
        return this.connectionFactoryCache;
    }

    public void clear() {
        this.connectionFactoryCache.invalidateAll();
    }
}

