/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.util.asm.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;

public abstract class BootstrapLoader {
    private static final BootstrapLoader loader = BootstrapLoader.create();

    public static BootstrapLoader get() {
        return loader;
    }

    private static BootstrapLoader create() {
        try {
            return new BootstrapLoaderImpl();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, "Searching for java.lang.ClassLoader.bootstrapClassLoader");
            try {
                Field field = ClassLoader.class.getDeclaredField("bootstrapClassLoader");
                field.setAccessible(true);
                ClassLoader cl = (ClassLoader)field.get(null);
                Agent.LOG.log(Level.FINEST, "Initializing IBM BootstrapLoader");
                return new IBMBootstrapLoader(cl);
            }
            catch (Exception ex) {
                Agent.LOG.log(Level.FINEST, "IBM Bootstrap loader lookup failed", ex);
                Agent.LOG.log(Level.FINEST, e.toString(), e);
                return new BootstrapLoader(){

                    public URL getBootstrapResource(String name) {
                        return null;
                    }

                    public boolean isBootstrapClass(String internalName) {
                        return internalName.startsWith("java/");
                    }
                };
            }
        }
    }

    public boolean isBootstrapClass(String internalName) {
        URL bootstrapResource = this.getBootstrapResource(Utils.getClassResourceName(internalName));
        return bootstrapResource != null;
    }

    public abstract URL getBootstrapResource(String var1);

    private static class IBMBootstrapLoader
    extends BootstrapLoader {
        private final ClassLoader bootstrapLoader;

        public IBMBootstrapLoader(ClassLoader cl) {
            this.bootstrapLoader = cl;
        }

        public URL getBootstrapResource(String name) {
            return this.bootstrapLoader.getResource(name);
        }
    }

    private static class BootstrapLoaderImpl
    extends BootstrapLoader {
        private final Method getBootstrapResourceMethod = ClassLoader.class.getDeclaredMethod("getBootstrapResource", String.class);

        private BootstrapLoaderImpl() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.getBootstrapResourceMethod.setAccessible(true);
            this.getBootstrapResourceMethod.invoke(null, "dummy");
        }

        public URL getBootstrapResource(String name) {
            try {
                return (URL)this.getBootstrapResourceMethod.invoke(null, name);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.FINEST, e.toString(), e);
                return null;
            }
        }
    }
}

