/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.logging.Level;

public class PatchedClassWriter
extends ClassWriter {
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    protected final ClassResolver classResolver;

    public PatchedClassWriter(int flags, ClassLoader classLoader) {
        this(flags, ClassResolvers.getClassLoaderResolver(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader));
    }

    public PatchedClassWriter(int flags, ClassResolver classResolver) {
        super(flags);
        this.classResolver = classResolver;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        if (type1.equals(type2)) {
            return type1;
        }
        if (JAVA_LANG_OBJECT.equals(type1) || JAVA_LANG_OBJECT.equals(type2)) {
            return JAVA_LANG_OBJECT;
        }
        try {
            ClassReader reader1 = this.getClassReader(type1);
            ClassReader reader2 = this.getClassReader(type2);
            if (reader1 == null || reader2 == null) {
                return JAVA_LANG_OBJECT;
            }
            String superClass = this.getCommonSuperClass(reader1, reader2);
            if (superClass == null) {
                return JAVA_LANG_OBJECT;
            }
            return superClass;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JAVA_LANG_OBJECT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassReader getClassReader(String type) throws IOException {
        ClassReader classReader;
        block4: {
            InputStream classResource = null;
            try {
                classResource = this.classResolver.getClassResource(type);
                classReader = classResource == null ? null : new ClassReader(classResource);
                Object var6_5 = null;
                if (classResource == null) break block4;
            }
            catch (IOException ex) {
                ClassReader classReader2;
                block5: {
                    try {
                        Agent.LOG.log(Level.FINEST, ex.toString(), ex);
                        classReader2 = null;
                        Object var6_6 = null;
                        if (classResource == null) break block5;
                    }
                    catch (Throwable throwable) {
                        block6: {
                            Object var6_7 = null;
                            if (classResource == null) break block6;
                            classResource.close();
                        }
                        throw throwable;
                    }
                    classResource.close();
                }
                return classReader2;
            }
            classResource.close();
        }
        return classReader;
    }

    private String getCommonSuperClass(ClassReader reader1, ClassReader reader2) throws ClassNotFoundException, IOException {
        if (this.isAssignableFrom(reader1, reader2)) {
            return reader1.getClassName();
        }
        if (this.isAssignableFrom(reader2, reader1)) {
            return reader2.getClassName();
        }
        if (this.isInterface(reader1) || this.isInterface(reader2)) {
            return JAVA_LANG_OBJECT;
        }
        HashSet<String> classes = Sets.newHashSet();
        classes.add(reader1.getClassName());
        while (reader1.getSuperName() != null) {
            classes.add(reader1.getSuperName());
            reader1 = this.getClassReader(reader1.getSuperName());
        }
        while (reader2.getSuperName() != null) {
            if (classes.contains(reader2.getClassName())) {
                return reader2.getClassName();
            }
            reader2 = this.getClassReader(reader2.getSuperName());
        }
        return null;
    }

    private boolean isInterface(ClassReader reader) {
        return (reader.getAccess() & 0x200) != 0;
    }

    private boolean isAssignableFrom(ClassReader reader1, ClassReader reader2) {
        return reader1.getClassName().equals(reader2.getClassName()) || reader1.getClassName().equals(reader2.getSuperName());
    }
}

