/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import nextapp.echo.app.Command;
import nextapp.echo.app.Component;
import nextapp.echo.app.DelegateFocusSupport;
import nextapp.echo.app.LayoutDirection;
import nextapp.echo.app.ModalSupport;
import nextapp.echo.app.Style;
import nextapp.echo.app.StyleSheet;
import nextapp.echo.app.TaskQueueHandle;
import nextapp.echo.app.Window;
import nextapp.echo.app.update.ServerUpdateManager;
import nextapp.echo.app.update.UpdateManager;
import nextapp.echo.app.util.Uid;

public abstract class ApplicationInstance
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final String ID_STRING = "NextApp Echo v3.0.rc1";
    public static final String FOCUSED_COMPONENT_CHANGED_PROPERTY = "focusedComponent";
    public static final String LOCALE_CHANGED_PROPERTY = "locale";
    public static final String MODAL_COMPONENTS_CHANGED_PROPERTY = "modalComponents";
    public static final String STYLE_SHEET_CHANGED_PROPERTY = "styleSheet";
    public static final String WINDOWS_CHANGED_PROPERTY = "windows";
    private static final ThreadLocal activeInstance = new ThreadLocal();
    private transient WeakReference focusedComponent;
    private Locale locale = Locale.getDefault();
    private LayoutDirection layoutDirection = LayoutDirection.forLocale(this.locale);
    private Map context;
    private Map renderIdToComponentMap;
    private HashMap taskQueueMap;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private UpdateManager updateManager = new UpdateManager(this);
    private Window defaultWindow;
    private StyleSheet styleSheet;
    private List modalComponents;
    private long nextId;

    private static Component findCurrentModalComponent(Component searchComponent, Set visibleModalComponents) {
        int count = searchComponent.getComponentCount();
        for (int i = count - 1; i >= 0; --i) {
            Component foundComponent = ApplicationInstance.findCurrentModalComponent(searchComponent.getComponent(i), visibleModalComponents);
            if (foundComponent == null) continue;
            return foundComponent;
        }
        if (searchComponent instanceof ModalSupport && ((ModalSupport)((Object)searchComponent)).isModal() && visibleModalComponents.contains(searchComponent)) {
            return searchComponent;
        }
        return null;
    }

    public static final String generateSystemId() {
        return Uid.generateUidString();
    }

    public static final ApplicationInstance getActive() {
        return (ApplicationInstance)activeInstance.get();
    }

    public static final void setActive(ApplicationInstance applicationInstance) {
        activeInstance.set(applicationInstance);
    }

    public ApplicationInstance() {
        this.renderIdToComponentMap = new HashMap();
        this.taskQueueMap = new HashMap();
    }

    public void activate() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskQueueHandle createTaskQueue() {
        TaskQueueHandle taskQueue = new TaskQueueHandle(){
            private static final long serialVersionUID = 20070101L;
        };
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            this.taskQueueMap.put(taskQueue, null);
        }
        return taskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.defaultWindow != null) {
            this.defaultWindow.doDispose();
            this.defaultWindow.register(null);
        }
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            this.taskQueueMap.clear();
        }
    }

    public final Window doInit() {
        if (this != activeInstance.get()) {
            throw new IllegalStateException("Attempt to update state of application user interface outside of user interface thread.");
        }
        Window window = this.init();
        this.setDefaultWindow(window);
        this.doValidation();
        return window;
    }

    public final void doValidation() {
        this.doValidation(this.defaultWindow);
    }

    private void doValidation(Component c) {
        c.validate();
        int size = c.getComponentCount();
        for (int index = 0; index < size; ++index) {
            this.doValidation(c.getComponent(index));
        }
    }

    public void enqueueCommand(Command command) {
        this.updateManager.getServerUpdateManager().enqueueCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueTask(TaskQueueHandle taskQueue, Runnable task) {
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            ArrayList<Runnable> taskList = (ArrayList<Runnable>)this.taskQueueMap.get(taskQueue);
            if (taskList == null) {
                taskList = new ArrayList<Runnable>();
                this.taskQueueMap.put(taskQueue, taskList);
            }
            taskList.add(task);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String generateId() {
        return Long.toString(this.nextId++);
    }

    public Object getContextProperty(String propertyName) {
        return this.context == null ? null : this.context.get(propertyName);
    }

    public Component getComponentByRenderId(String renderId) {
        return (Component)this.renderIdToComponentMap.get(renderId);
    }

    public Window getDefaultWindow() {
        return this.defaultWindow;
    }

    public Component getFocusedComponent() {
        if (this.focusedComponent == null) {
            return null;
        }
        return (Component)this.focusedComponent.get();
    }

    public LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Component getModalContextRoot() {
        if (this.modalComponents == null || this.modalComponents.size() == 0) {
            return null;
        }
        if (this.modalComponents.size() == 1) {
            Component component = (Component)this.modalComponents.get(0);
            return component.isRenderVisible() ? component : null;
        }
        HashSet<Component> visibleModalComponents = new HashSet<Component>();
        for (int i = this.modalComponents.size() - 1; i >= 0; --i) {
            Component component = (Component)this.modalComponents.get(i);
            if (!component.isRenderVisible()) continue;
            visibleModalComponents.add(component);
        }
        return ApplicationInstance.findCurrentModalComponent(this.getDefaultWindow(), visibleModalComponents);
    }

    public Style getStyle(Class componentClass, String styleName) {
        if (this.styleSheet == null) {
            return null;
        }
        return this.styleSheet.getStyle(styleName, componentClass, true);
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public final boolean hasTaskQueues() {
        return this.taskQueueMap.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQueuedTasks() {
        if (this.taskQueueMap.size() == 0) {
            return false;
        }
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            Iterator it = this.taskQueueMap.values().iterator();
            while (it.hasNext()) {
                List taskList = (List)it.next();
                if (taskList == null || taskList.size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isModal(Component component) {
        return this.modalComponents != null && this.modalComponents.contains(component);
    }

    public abstract Window init();

    void notifyComponentPropertyChange(Component parent, String propertyName, Object oldValue, Object newValue) {
        if (this != activeInstance.get()) {
            throw new IllegalStateException("Attempt to update state of application user interface outside of user interface thread.");
        }
        ServerUpdateManager serverUpdateManager = this.updateManager.getServerUpdateManager();
        if ("children".equals(propertyName)) {
            if (newValue == null) {
                serverUpdateManager.processComponentRemove(parent, (Component)oldValue);
            } else {
                serverUpdateManager.processComponentAdd(parent, (Component)newValue);
            }
        } else if ("layoutData".equals(propertyName)) {
            serverUpdateManager.processComponentLayoutDataUpdate(parent);
        } else if ("visible".equals(propertyName)) {
            if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                return;
            }
            serverUpdateManager.processComponentVisibilityUpdate(parent);
        } else {
            if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                return;
            }
            if (parent instanceof ModalSupport && "modal".equals(propertyName)) {
                this.setModal(parent, (Boolean)newValue);
            }
            serverUpdateManager.processComponentPropertyUpdate(parent, propertyName, oldValue, newValue);
        }
    }

    public void passivate() {
    }

    public void processInput(String propertyName, Object propertyValue) {
        if (FOCUSED_COMPONENT_CHANGED_PROPERTY.equals(propertyName)) {
            this.setFocusedComponent((Component)propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueuedTasks() {
        if (this.taskQueueMap.size() == 0) {
            return;
        }
        ArrayList currentTasks = new ArrayList();
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            Iterator taskListsIt = this.taskQueueMap.values().iterator();
            while (taskListsIt.hasNext()) {
                List tasks = (List)taskListsIt.next();
                if (tasks == null) continue;
                currentTasks.addAll(tasks);
                tasks.clear();
            }
        }
        Iterator it = currentTasks.iterator();
        while (it.hasNext()) {
            ((Runnable)it.next()).run();
        }
    }

    void registerComponent(Component component) {
        String renderId = component.getRenderId();
        if (renderId == null || this.renderIdToComponentMap.containsKey(renderId)) {
            component.assignRenderId(this.generateId());
        }
        this.renderIdToComponentMap.put(component.getRenderId(), component);
        if (component instanceof ModalSupport && ((ModalSupport)((Object)component)).isModal()) {
            this.setModal(component, true);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskQueue(TaskQueueHandle taskQueueHandle) {
        HashMap hashMap = this.taskQueueMap;
        synchronized (hashMap) {
            this.taskQueueMap.remove(taskQueueHandle);
        }
    }

    public void setContextProperty(String propertyName, Object propertyValue) {
        if (this.context == null) {
            this.context = new HashMap();
        }
        if (propertyValue == null) {
            this.context.remove(propertyName);
        } else {
            this.context.put(propertyName, propertyValue);
        }
    }

    private void setDefaultWindow(Window window) {
        if (this.defaultWindow != null) {
            throw new UnsupportedOperationException("Default window already set.");
        }
        this.defaultWindow = window;
        window.register(this);
        this.firePropertyChange(WINDOWS_CHANGED_PROPERTY, null, window);
        window.doInit();
    }

    public void setFocusedComponent(Component newValue) {
        if (newValue instanceof DelegateFocusSupport) {
            newValue = ((DelegateFocusSupport)((Object)newValue)).getFocusComponent();
        }
        Component oldValue = this.getFocusedComponent();
        this.focusedComponent = newValue == null ? null : new WeakReference<Component>(newValue);
        this.propertyChangeSupport.firePropertyChange(FOCUSED_COMPONENT_CHANGED_PROPERTY, oldValue, newValue);
        this.updateManager.getServerUpdateManager().processApplicationPropertyUpdate(FOCUSED_COMPONENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setLocale(Locale newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("ApplicationInstance Locale may not be null.");
        }
        Locale oldValue = this.locale;
        this.locale = newValue;
        this.layoutDirection = LayoutDirection.forLocale(this.locale);
        this.propertyChangeSupport.firePropertyChange(LOCALE_CHANGED_PROPERTY, oldValue, newValue);
        this.updateManager.getServerUpdateManager().processFullRefresh();
    }

    private void setModal(Component component, boolean newValue) {
        boolean oldValue = this.isModal(component);
        if (newValue) {
            if (this.modalComponents == null) {
                this.modalComponents = new ArrayList();
            }
            if (!this.modalComponents.contains(component)) {
                this.modalComponents.add(component);
            }
        } else if (this.modalComponents != null) {
            this.modalComponents.remove(component);
        }
        this.firePropertyChange(MODAL_COMPONENTS_CHANGED_PROPERTY, new Boolean(oldValue), new Boolean(newValue));
    }

    public void setStyleSheet(StyleSheet newValue) {
        StyleSheet oldValue = this.styleSheet;
        this.styleSheet = newValue;
        this.firePropertyChange(STYLE_SHEET_CHANGED_PROPERTY, oldValue, newValue);
    }

    void unregisterComponent(Component component) {
        this.renderIdToComponentMap.remove(component.getRenderId());
        if (component instanceof ModalSupport && ((ModalSupport)((Object)component)).isModal()) {
            this.setModal(component, false);
        }
    }

    boolean verifyModalContext(Component component) {
        Component modalContextRoot = this.getModalContextRoot();
        return modalContextRoot == null || modalContextRoot.isAncestorOf(component);
    }
}

