/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;
import nextapp.echo.app.Color;
import nextapp.echo.app.Extent;

public class Border
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final int SIDE_TOP = 0;
    public static final int SIDE_RIGHT = 1;
    public static final int SIDE_BOTTOM = 2;
    public static final int SIDE_LEFT = 3;
    public static final int STYLE_NONE = 0;
    public static final int STYLE_SOLID = 1;
    public static final int STYLE_INSET = 2;
    public static final int STYLE_OUTSET = 3;
    public static final int STYLE_GROOVE = 4;
    public static final int STYLE_RIDGE = 5;
    public static final int STYLE_DOUBLE = 6;
    public static final int STYLE_DOTTED = 7;
    public static final int STYLE_DASHED = 8;
    private Side[] sides;

    public Border(int sizePx, Color color, int style) {
        this(new Extent(sizePx), color, style);
    }

    public Border(Extent size, Color color, int style) {
        this.sides = new Side[]{new Side(size, color, style)};
    }

    public Border(Side[] sides) {
        if (sides.length < 1 || sides.length > 4) {
            throw new IllegalArgumentException("Invalid number of border sides: " + sides.length);
        }
        this.sides = sides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Border)) {
            return false;
        }
        Border that = (Border)o;
        if (this.sides.length != that.sides.length) {
            return false;
        }
        for (int i = 0; i < this.sides.length; ++i) {
            if (this.sides[i] == that.sides[i] || this.sides[i] != null && this.sides[i].equals(that.sides[i])) continue;
            return false;
        }
        return true;
    }

    public Color getColor() {
        return this.sides[0].getColor();
    }

    public Extent getSize() {
        return this.sides[0].getSize();
    }

    public int getStyle() {
        return this.sides[0].getStyle();
    }

    public Side[] getSides() {
        return this.sides;
    }

    public boolean isMultisided() {
        return this.sides.length > 1;
    }

    public static class Side
    implements Serializable {
        private static final long serialVersionUID = 20070101L;
        private Extent size;
        private Color color;
        private int style;

        public Side(int sizePx, Color color, int style) {
            this(new Extent(sizePx), color, style);
        }

        public Side(Extent size, Color color, int style) {
            this.size = size;
            this.color = color;
            this.style = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Side)) {
                return false;
            }
            Side that = (Side)o;
            if (this.style != that.style) {
                return false;
            }
            if (this.color == null ? that.color != null : !this.color.equals(that.color)) {
                return false;
            }
            return !(this.size == null ? that.size != null : !this.size.equals(that.size));
        }

        public Color getColor() {
            return this.color;
        }

        public Extent getSize() {
            return this.size;
        }

        public int getStyle() {
            return this.style;
        }
    }
}

