/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app;

import java.io.Serializable;

public class Extent
implements Comparable,
Serializable {
    private static final long serialVersionUID = 20070101L;
    public static final int PX = 1;
    public static final int PERCENT = 2;
    public static final int PT = 4;
    public static final int CM = 8;
    public static final int MM = 16;
    public static final int IN = 32;
    public static final int EM = 64;
    public static final int EX = 128;
    public static final int PC = 256;
    private final int value;
    private final int units;

    public static Extent add(Extent a, Extent b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.getUnits() == b.getUnits()) {
            return new Extent(a.getValue() + b.getValue(), a.getUnits());
        }
        if (a.isPrint() && b.isPrint()) {
            if (a.isEnglish() && b.isEnglish()) {
                return new Extent(a.toPoint() + b.toPoint(), 4);
            }
            return new Extent(a.toMm() + b.toMm(), 16);
        }
        return null;
    }

    public static void validate(Extent value, int validUnits) {
        if (value != null && (value.getUnits() & validUnits) == 0) {
            throw new IllegalArgumentException("Specified units are unsupported in this context.");
        }
    }

    static String getUnitsString(int units) {
        switch (units) {
            case 8: {
                return "cm";
            }
            case 64: {
                return "em";
            }
            case 128: {
                return "ex";
            }
            case 32: {
                return "in";
            }
            case 16: {
                return "mm";
            }
            case 256: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 4: {
                return "pt";
            }
        }
        return "px";
    }

    public Extent(int value) {
        this.value = value;
        this.units = 1;
    }

    public Extent(int value, int units) {
        this.value = value;
        this.units = units;
    }

    public int compareTo(Object o) {
        Extent that = (Extent)o;
        if (this.units == that.units) {
            return this.value - that.value;
        }
        if (this.isPrint() && that.isPrint()) {
            return this.toPoint() - that.toPoint();
        }
        return this.units - that.units;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Extent) {
            Extent that = (Extent)o;
            return this.value == that.value && this.units == that.units;
        }
        return false;
    }

    public int getValue() {
        return this.value;
    }

    public int getUnits() {
        return this.units;
    }

    public boolean isComparableTo(Extent that) {
        return this.units == that.units || this.isPrint() && that.isPrint();
    }

    public boolean isEnglish() {
        return this.units == 32 || this.units == 256 || this.units == 4;
    }

    public boolean isSI() {
        return this.units == 16 || this.units == 8;
    }

    public boolean isPercentage() {
        return this.units == 2;
    }

    public boolean isPrint() {
        return this.units == 32 || this.units == 256 || this.units == 4 || this.units == 16 || this.units == 8;
    }

    public int toMm() {
        switch (this.units) {
            case 16: {
                return this.value;
            }
            case 8: {
                return this.value * 10;
            }
            case 32: {
                return (int)((double)this.value * 25.4);
            }
            case 4: {
                return (int)((double)(this.value / 72) * 25.4);
            }
            case 256: {
                return (int)((double)(this.value / 6) * 25.4);
            }
        }
        throw new IllegalStateException("Cannot convert to mm.");
    }

    public int toPoint() {
        switch (this.units) {
            case 4: {
                return this.value;
            }
            case 256: {
                return this.value * 12;
            }
            case 32: {
                return this.value * 72;
            }
            case 16: {
                return (int)((double)this.value / 25.4 * 72.0);
            }
            case 8: {
                return (int)((double)this.value / 2.54 * 72.0);
            }
        }
        throw new IllegalStateException("Cannot convert to pt.");
    }

    public String toString() {
        return this.value + Extent.getUnitsString(this.units);
    }
}

