/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.list;

import java.util.EventListener;
import nextapp.echo.app.Border;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Font;
import nextapp.echo.app.Insets;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.app.event.ListDataEvent;
import nextapp.echo.app.event.ListDataListener;
import nextapp.echo.app.list.DefaultListCellRenderer;
import nextapp.echo.app.list.DefaultListModel;
import nextapp.echo.app.list.DefaultListSelectionModel;
import nextapp.echo.app.list.ListCellRenderer;
import nextapp.echo.app.list.ListModel;
import nextapp.echo.app.list.ListSelectionModel;

public abstract class AbstractListComponent
extends Component {
    public static final String INPUT_ACTION = "action";
    public static final String PROPERTY_ACTION_COMMAND = "actionCommand";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String LIST_DATA_CHANGED_PROPERTY = "listData";
    public static final String LIST_MODEL_CHANGED_PROPERTY = "listModel";
    public static final String LIST_CELL_RENDERER_CHANGED_PROPERTY = "listCellRenderer";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY = "listSelectionModel";
    public static final String SELECTION_CHANGED_PROPERTY = "listSelectionChanged";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_DISABLED_BACKGROUND = "disabledBackground";
    public static final String PROPERTY_DISABLED_BORDER = "disabledBorder";
    public static final String PROPERTY_DISABLED_FONT = "disabledFont";
    public static final String PROPERTY_DISABLED_FOREGROUND = "disabledForeground";
    public static final String PROPERTY_HEIGHT = "height";
    public static final String PROPERTY_INSETS = "insets";
    public static final String PROPERTY_ROLLOVER_BACKGROUND = "rolloverBackground";
    public static final String PROPERTY_ROLLOVER_ENABLED = "rolloverEnabled";
    public static final String PROPERTY_ROLLOVER_FONT = "rolloverFont";
    public static final String PROPERTY_ROLLOVER_FOREGROUND = "rolloverForeground";
    public static final String PROPERTY_TOOL_TIP_TEXT = "toolTipText";
    public static final String PROPERTY_WIDTH = "width";
    public static final DefaultListCellRenderer DEFAULT_LIST_CELL_RENDERER = new DefaultListCellRenderer();
    private ChangeListener changeHandler = new ChangeListener(){
        private static final long serialVersionUID = 20070101L;

        public void stateChanged(ChangeEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.SELECTION_CHANGED_PROPERTY, null, null);
        }
    };
    private ListDataListener listDataHandler = new ListDataListener(){
        private static final long serialVersionUID = 20070101L;

        public void contentsChanged(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalAdded(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }

        public void intervalRemoved(ListDataEvent e) {
            AbstractListComponent.this.firePropertyChange(AbstractListComponent.LIST_DATA_CHANGED_PROPERTY, null, null);
        }
    };
    private ListCellRenderer listCellRenderer = DEFAULT_LIST_CELL_RENDERER;
    private ListModel model;
    private ListSelectionModel selectionModel;

    public AbstractListComponent() {
        this(null, null);
    }

    public AbstractListComponent(ListModel model, ListSelectionModel selectionModel) {
        if (model == null) {
            model = new DefaultListModel();
        }
        if (selectionModel == null) {
            selectionModel = new DefaultListSelectionModel();
        }
        this.setModel(model);
        this.setSelectionModel(selectionModel);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, null, l);
    }

    private void fireActionEvent() {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, (String)this.getRenderProperty(PROPERTY_ACTION_COMMAND));
            }
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public String getActionCommand() {
        return (String)this.get(PROPERTY_ACTION_COMMAND);
    }

    public Border getBorder() {
        return (Border)this.get(PROPERTY_BORDER);
    }

    public ListCellRenderer getCellRenderer() {
        return this.listCellRenderer;
    }

    public Color getDisabledBackground() {
        return (Color)this.get(PROPERTY_DISABLED_BACKGROUND);
    }

    public Border getDisabledBorder() {
        return (Border)this.get(PROPERTY_DISABLED_BORDER);
    }

    public Font getDisabledFont() {
        return (Font)this.get(PROPERTY_DISABLED_FONT);
    }

    public Color getDisabledForeground() {
        return (Color)this.get(PROPERTY_DISABLED_FOREGROUND);
    }

    public Extent getHeight() {
        return (Extent)this.get(PROPERTY_HEIGHT);
    }

    public Insets getInsets() {
        return (Insets)this.get(PROPERTY_INSETS);
    }

    public ListModel getModel() {
        return this.model;
    }

    public Color getRolloverBackground() {
        return (Color)this.get(PROPERTY_ROLLOVER_BACKGROUND);
    }

    public Font getRolloverFont() {
        return (Font)this.get(PROPERTY_ROLLOVER_FONT);
    }

    public Color getRolloverForeground() {
        return (Color)this.get(PROPERTY_ROLLOVER_FOREGROUND);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getToolTipText() {
        return (String)this.get(PROPERTY_TOOL_TIP_TEXT);
    }

    public Extent getWidth() {
        return (Extent)this.get(PROPERTY_WIDTH);
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    public boolean isRolloverEnabled() {
        Boolean value = (Boolean)this.get(PROPERTY_ROLLOVER_ENABLED);
        return value == null ? false : value;
    }

    public boolean isValidChild(Component child) {
        return false;
    }

    public void processInput(String inputName, Object inputValue) {
        super.processInput(inputName, inputValue);
        if (SELECTION_CHANGED_PROPERTY.equals(inputName)) {
            int[] selectedIndices = (int[])inputValue;
            ListSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.clearSelection();
            for (int i = 0; i < selectedIndices.length; ++i) {
                selectionModel.setSelectedIndex(selectedIndices[i], true);
            }
        } else if (INPUT_ACTION.equals(inputName)) {
            this.fireActionEvent();
        }
    }

    public void removeActionListener(ActionListener l) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, l);
        this.firePropertyChange(ACTION_LISTENERS_CHANGED_PROPERTY, l, null);
    }

    public void setActionCommand(String newValue) {
        this.set(PROPERTY_ACTION_COMMAND, newValue);
    }

    public void setBorder(Border newValue) {
        this.set(PROPERTY_BORDER, newValue);
    }

    public void setCellRenderer(ListCellRenderer newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Cell Renderer may not be null.");
        }
        ListCellRenderer oldValue = this.listCellRenderer;
        this.listCellRenderer = newValue;
        this.firePropertyChange(LIST_CELL_RENDERER_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDisabledBackground(Color newValue) {
        this.set(PROPERTY_DISABLED_BACKGROUND, newValue);
    }

    public void setDisabledBorder(Border newValue) {
        this.set(PROPERTY_DISABLED_BORDER, newValue);
    }

    public void setDisabledFont(Font newValue) {
        this.set(PROPERTY_DISABLED_FONT, newValue);
    }

    public void setDisabledForeground(Color newValue) {
        this.set(PROPERTY_DISABLED_FOREGROUND, newValue);
    }

    public void setHeight(Extent newValue) {
        this.set(PROPERTY_HEIGHT, newValue);
    }

    public void setInsets(Insets newValue) {
        this.set(PROPERTY_INSETS, newValue);
    }

    public void setModel(ListModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Model may not be null.");
        }
        ListModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeListDataListener(this.listDataHandler);
        }
        newValue.addListDataListener(this.listDataHandler);
        this.model = newValue;
        this.firePropertyChange(LIST_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRolloverBackground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_BACKGROUND, newValue);
    }

    public void setRolloverEnabled(boolean newValue) {
        this.set(PROPERTY_ROLLOVER_ENABLED, new Boolean(newValue));
    }

    public void setRolloverFont(Font newValue) {
        this.set(PROPERTY_ROLLOVER_FONT, newValue);
    }

    public void setRolloverForeground(Color newValue) {
        this.set(PROPERTY_ROLLOVER_FOREGROUND, newValue);
    }

    public void setSelectionModel(ListSelectionModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Selection model may not be null.");
        }
        ListSelectionModel oldValue = this.selectionModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.changeHandler);
        }
        newValue.addChangeListener(this.changeHandler);
        this.selectionModel = newValue;
        this.firePropertyChange(SELECTION_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setToolTipText(String newValue) {
        this.set(PROPERTY_TOOL_TIP_TEXT, newValue);
    }

    public void setWidth(Extent newValue) {
        this.set(PROPERTY_WIDTH, newValue);
    }
}

