/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.DecimalExtent;
import nextapp.echo.app.Extent;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.util.ConstantMap;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class ExtentPeer
implements SerialPropertyPeer {
    private static final ConstantMap suffixConstantMap = new ConstantMap();

    public static Extent fromString(String value) throws SerialException {
        if (value == null) {
            return null;
        }
        value = value.trim();
        int separatorPoint = -1;
        int length = value.length();
        for (int i = length - 1; i >= 0; --i) {
            char ch = value.charAt(i);
            if (!Character.isDigit(ch) && ch != '.') continue;
            separatorPoint = i + 1;
            break;
        }
        if (separatorPoint == -1) {
            throw new SerialException("Cannot create extent from value: " + value, null);
        }
        String valueString = value.substring(0, separatorPoint);
        String unitString = value.substring(separatorPoint);
        int extentUnits = suffixConstantMap.get(unitString, -1);
        try {
            if (valueString.indexOf(46) == -1) {
                int extentValue = Integer.parseInt(valueString);
                if (extentUnits == -1) {
                    return new Extent(extentValue);
                }
                return new Extent(extentValue, extentUnits);
            }
            double decimalExtentValue = Double.parseDouble(valueString);
            if (extentUnits == -1) {
                return new DecimalExtent(decimalExtentValue);
            }
            return new DecimalExtent(decimalExtentValue, extentUnits);
        }
        catch (NumberFormatException ex) {
            throw new SerialException("Cannot create extent from value: " + value, ex);
        }
    }

    public static String toString(Extent extent) throws SerialException {
        if (extent instanceof DecimalExtent) {
            return ((DecimalExtent)extent).getDecimalValue() + suffixConstantMap.get(extent.getUnits());
        }
        return extent.getValue() + suffixConstantMap.get(extent.getUnits());
    }

    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        return ExtentPeer.fromString(propertyElement.hasAttribute("v") ? propertyElement.getAttribute("v") : DomUtil.getElementText(propertyElement));
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        propertyElement.appendChild(propertyElement.getOwnerDocument().createTextNode(ExtentPeer.toString((Extent)propertyValue)));
    }

    static {
        suffixConstantMap.add(1, "px");
        suffixConstantMap.add(8, "cm");
        suffixConstantMap.add(64, "em");
        suffixConstantMap.add(128, "ex");
        suffixConstantMap.add(32, "in");
        suffixConstantMap.add(16, "mm");
        suffixConstantMap.add(256, "pc");
        suffixConstantMap.add(4, "pt");
        suffixConstantMap.add(2, "%");
    }
}

