/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.serial.property;

import nextapp.echo.app.Extent;
import nextapp.echo.app.ResourceImageReference;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ExtentPeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.app.util.DomUtil;
import org.w3c.dom.Element;

public class ResourceImageReferencePeer
implements SerialPropertyPeer {
    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        Element iElement = DomUtil.getChildElementByTagName(propertyElement, "i");
        if (iElement == null) {
            return new ResourceImageReference(DomUtil.getElementText(propertyElement));
        }
        String url = DomUtil.getElementText(iElement);
        if (url == null) {
            url = iElement.getAttribute("r");
        }
        String contentType = iElement.hasAttribute("t") ? iElement.getAttribute("t") : null;
        Extent width = iElement.hasAttribute("w") ? ExtentPeer.fromString(iElement.getAttribute("w")) : null;
        Extent height = iElement.hasAttribute("h") ? ExtentPeer.fromString(iElement.getAttribute("h")) : null;
        return new ResourceImageReference(url, contentType, width, height);
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        ResourceImageReference resourceImage = (ResourceImageReference)propertyValue;
        Element iElement = serialContext.getDocument().createElement("i");
        propertyElement.appendChild(iElement);
        iElement.appendChild(serialContext.getDocument().createTextNode(resourceImage.getResource()));
        iElement.setAttribute("t", resourceImage.getContentType());
        if (resourceImage.getWidth() != null) {
            iElement.setAttribute("w", ExtentPeer.toString(resourceImage.getWidth()));
        }
        if (resourceImage.getHeight() != null) {
            iElement.setAttribute("h", ExtentPeer.toString(resourceImage.getHeight()));
        }
    }
}

