/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.app.update;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Command;
import nextapp.echo.app.Component;
import nextapp.echo.app.update.ClientComponentUpdate;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.update.PropertyUpdate;
import nextapp.echo.app.update.ServerComponentUpdate;

public class ServerUpdateManager
implements Serializable {
    private static final long serialVersionUID = 20070101L;
    private static final Comparator hierarchyDepthUpdateComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return this.getDepth(((ServerComponentUpdate)a).getParent()) - this.getDepth(((ServerComponentUpdate)b).getParent());
        }

        public boolean equals(Object o) {
            return false;
        }

        private int getDepth(Component component) {
            int count = 0;
            while (component != null) {
                component = component.getParent();
                ++count;
            }
            return count;
        }
    };
    private static final Command[] EMPTY_COMMAND_ARRAY = new Command[0];
    private Map applicationUpdateMap;
    private List commands;
    private Map componentUpdateMap;
    private ServerComponentUpdate fullRefreshUpdate;
    private ClientUpdateManager clientUpdateManager;
    private ApplicationInstance applicationInstance;
    private ServerComponentUpdate[] cachedComponentUpdates;

    public ServerUpdateManager(ApplicationInstance applicationInstance) {
        this.applicationInstance = applicationInstance;
        this.applicationUpdateMap = new HashMap();
        this.componentUpdateMap = new HashMap();
        this.fullRefreshUpdate = new ServerComponentUpdate(null);
    }

    private ServerComponentUpdate createComponentUpdate(Component parent) {
        ServerComponentUpdate update;
        if (this.componentUpdateMap.containsKey(parent)) {
            update = (ServerComponentUpdate)this.componentUpdateMap.get(parent);
        } else {
            update = new ServerComponentUpdate(parent);
            this.componentUpdateMap.put(parent, update);
        }
        return update;
    }

    public void enqueueCommand(Command command) {
        if (this.commands == null) {
            this.commands = new ArrayList();
        }
        this.commands.add(command);
    }

    public PropertyUpdate getApplicationPropertyUpdate(String propertyName) {
        return (PropertyUpdate)this.applicationUpdateMap.get(propertyName);
    }

    public Command[] getCommands() {
        if (this.commands == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        return this.commands.toArray(new Command[this.commands.size()]);
    }

    public ServerComponentUpdate[] getComponentUpdates() {
        if (this.isFullRefreshRequired()) {
            return new ServerComponentUpdate[]{this.fullRefreshUpdate};
        }
        if (this.cachedComponentUpdates == null) {
            Collection hierarchyUpdates = this.componentUpdateMap.values();
            this.cachedComponentUpdates = hierarchyUpdates.toArray(new ServerComponentUpdate[hierarchyUpdates.size()]);
            Arrays.sort(this.cachedComponentUpdates, hierarchyDepthUpdateComparator);
            return this.cachedComponentUpdates;
        }
        return this.cachedComponentUpdates;
    }

    public void init(ClientUpdateManager clientUpdateManager) {
        this.clientUpdateManager = clientUpdateManager;
    }

    private boolean isAncestorBeingAdded(Component component) {
        Component child = component;
        for (Component parent = component.getParent(); parent != null; parent = parent.getParent()) {
            ServerComponentUpdate update = (ServerComponentUpdate)this.componentUpdateMap.get(parent);
            if (update != null && update.hasAddedChild(child)) {
                return true;
            }
            child = parent;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.componentUpdateMap.size() == 0;
    }

    public boolean isFullRefreshRequired() {
        return this.fullRefreshUpdate != null;
    }

    public void processApplicationPropertyUpdate(String propertyName, Object oldValue, Object newValue) {
        Object clientValue = this.clientUpdateManager.getApplicationUpdatePropertyValue(propertyName);
        if (clientValue == newValue || clientValue != null && clientValue.equals(newValue)) {
            this.applicationUpdateMap.remove(propertyName);
        } else {
            this.applicationUpdateMap.put(propertyName, new PropertyUpdate(oldValue, newValue));
        }
    }

    public void processComponentAdd(Component parent, Component child) {
        if (this.isFullRefreshRequired()) {
            return;
        }
        if (!child.isRenderVisible()) {
            return;
        }
        if (this.isAncestorBeingAdded(child)) {
            return;
        }
        this.cachedComponentUpdates = null;
        ServerComponentUpdate update = this.createComponentUpdate(parent);
        update.addChild(child);
    }

    public void processComponentLayoutDataUpdate(Component updatedComponent) {
        if (this.isFullRefreshRequired()) {
            return;
        }
        if (!updatedComponent.isRenderVisible()) {
            return;
        }
        this.cachedComponentUpdates = null;
        Component parentComponent = updatedComponent.getParent();
        if (parentComponent == null || this.isAncestorBeingAdded(parentComponent)) {
            return;
        }
        ServerComponentUpdate update = this.createComponentUpdate(parentComponent);
        update.updateLayoutData(updatedComponent);
    }

    public void processComponentPropertyUpdate(Component updatedComponent, String propertyName, Object oldValue, Object newValue) {
        Object inputValue;
        if (this.isFullRefreshRequired()) {
            return;
        }
        if (!updatedComponent.isRenderVisible()) {
            return;
        }
        if (this.isAncestorBeingAdded(updatedComponent)) {
            return;
        }
        this.cachedComponentUpdates = null;
        ClientComponentUpdate clientComponentUpdate = this.clientUpdateManager.getComponentUpdate(updatedComponent);
        if (clientComponentUpdate != null && clientComponentUpdate.hasInput(propertyName) && ((inputValue = clientComponentUpdate.getInputValue(propertyName)) == newValue || inputValue != null && inputValue.equals(newValue))) {
            ServerComponentUpdate update = (ServerComponentUpdate)this.componentUpdateMap.get(updatedComponent);
            if (update != null) {
                update.cancelUpdateProperty(propertyName);
            }
            return;
        }
        ServerComponentUpdate update = this.createComponentUpdate(updatedComponent);
        update.updateProperty(propertyName, oldValue, newValue);
    }

    public void processComponentRemove(Component parent, Component child) {
        if (this.isFullRefreshRequired()) {
            return;
        }
        if (!parent.isRenderVisible()) {
            return;
        }
        if (this.isAncestorBeingAdded(parent)) {
            return;
        }
        this.cachedComponentUpdates = null;
        ServerComponentUpdate update = this.createComponentUpdate(parent);
        update.removeChild(child);
        Iterator it = this.componentUpdateMap.keySet().iterator();
        while (it.hasNext()) {
            Component testComponent = (Component)it.next();
            if (!child.isAncestorOf(testComponent)) continue;
            ServerComponentUpdate childUpdate = (ServerComponentUpdate)this.componentUpdateMap.get(testComponent);
            update.appendRemovedDescendants(childUpdate);
            it.remove();
        }
    }

    public void processComponentVisibilityUpdate(Component updatedComponent) {
        this.cachedComponentUpdates = null;
        Component parentComponent = updatedComponent.getParent();
        if (updatedComponent.isVisible()) {
            this.processComponentAdd(parentComponent, updatedComponent);
        } else {
            this.processComponentRemove(parentComponent, updatedComponent);
        }
    }

    public void processFullRefresh() {
        if (this.fullRefreshUpdate != null) {
            return;
        }
        this.cachedComponentUpdates = null;
        this.fullRefreshUpdate = new ServerComponentUpdate(null);
        if (this.applicationInstance.getDefaultWindow() != null) {
            this.fullRefreshUpdate.removeDescendant(this.applicationInstance.getDefaultWindow());
        }
        Iterator it = this.componentUpdateMap.keySet().iterator();
        while (it.hasNext()) {
            Component testComponent = (Component)it.next();
            ServerComponentUpdate childUpdate = (ServerComponentUpdate)this.componentUpdateMap.get(testComponent);
            this.fullRefreshUpdate.appendRemovedDescendants(childUpdate);
            it.remove();
        }
    }

    void purge() {
        this.applicationUpdateMap.clear();
        this.componentUpdateMap.clear();
        this.commands = null;
        this.fullRefreshUpdate = null;
        this.cachedComponentUpdates = null;
    }
}

