/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;

public class ColorSelect
extends Component {
    public static final String COLOR_CHANGED_PROPERTY = "color";
    public static final String PROPERTY_HUE_WIDTH = "hueWidth";
    public static final String PROPERTY_SATURATION_HEIGHT = "saturationHeight";
    public static final String PROPERTY_VALUE_WIDTH = "valueWidth";
    public static final String PROPERTY_DISPLAY_VALUE = "displayValue";
    private Color color;

    public ColorSelect() {
        this(Color.BLACK);
    }

    public ColorSelect(Color color) {
        this.setColor(color);
    }

    public Color getColor() {
        return this.color;
    }

    public Extent getHueWidth() {
        return (Extent)this.get(PROPERTY_HUE_WIDTH);
    }

    public Extent getSaturationHeight() {
        return (Extent)this.get(PROPERTY_SATURATION_HEIGHT);
    }

    public Extent getValueWidth() {
        return (Extent)this.get(PROPERTY_VALUE_WIDTH);
    }

    public boolean isDisplayValue() {
        Boolean value = (Boolean)this.get(PROPERTY_DISPLAY_VALUE);
        return value == null ? true : value;
    }

    public void processInput(String inputName, Object inputValue) {
        if (COLOR_CHANGED_PROPERTY.equals(inputName)) {
            this.setColor((Color)inputValue);
        }
    }

    public void setColor(Color newValue) {
        if (newValue == null) {
            newValue = Color.WHITE;
        }
        Color oldValue = this.color;
        this.color = newValue;
        this.firePropertyChange(COLOR_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setDisplayValue(boolean newValue) {
        this.set(PROPERTY_DISPLAY_VALUE, new Boolean(newValue));
    }

    public void setHueWidth(Extent newValue) {
        this.set(PROPERTY_HUE_WIDTH, newValue);
    }

    public void setSaturationHeight(Extent newValue) {
        this.set(PROPERTY_SATURATION_HEIGHT, newValue);
    }

    public void setValueWidth(Extent newValue) {
        this.set(PROPERTY_VALUE_WIDTH, newValue);
    }
}

