/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app;

import nextapp.echo.app.Component;
import nextapp.echo.extras.app.datagrid.AbstractDataGridModel;
import nextapp.echo.extras.app.datagrid.DataGridModel;
import nextapp.echo.extras.app.event.DataGridModelEvent;
import nextapp.echo.extras.app.event.DataGridModelListener;

public class DataGrid
extends Component {
    public static final String COLUMN_INDEX_CHANGED_PROPERTY = "columnIndex";
    public static final String COLUMN_PERCENT_CHANGED_PROPERTY = "columnPercent";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String ROW_INDEX_CHANGED_PROPERTY = "rowIndex";
    public static final String ROW_PERCENT_CHANGED_PROPERTY = "rowPercent";
    private DataGridModelListener modelListener = new DataGridModelListener(){
        private static final long serialVersionUID = 20070101L;

        public void modelChanged(DataGridModelEvent e) {
            DataGrid.this.firePropertyChange(DataGrid.MODEL_CHANGED_PROPERTY, null, null);
        }
    };
    private Number columnIndex;
    private Number columnPercent;
    private Number rowIndex;
    private Number rowPercent;
    private DataGridModel model;

    public DataGrid() {
        this(new EmptyDataGridModel());
    }

    public DataGrid(DataGridModel model) {
        this.setModel(model);
    }

    public Number getColumnIndex() {
        return this.columnIndex;
    }

    public Number getColumnPercent() {
        return this.columnPercent;
    }

    public DataGridModel getModel() {
        return this.model;
    }

    public Number getRowIndex() {
        return this.rowIndex;
    }

    public Number getRowPercent() {
        return this.rowPercent;
    }

    public void setColumnIndex(Number newValue) {
        if (this.columnPercent != null) {
            this.setColumnPercent(null);
        }
        Number oldValue = this.columnIndex;
        this.columnIndex = newValue;
        this.firePropertyChange(COLUMN_INDEX_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setColumnPercent(Number newValue) {
        if (this.columnIndex != null) {
            this.setColumnIndex(null);
        }
        Number oldValue = this.columnPercent;
        this.columnPercent = newValue;
        this.firePropertyChange(COLUMN_PERCENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setModel(DataGridModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("The model may not be null.");
        }
        DataGridModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeDataGridModelListener(this.modelListener);
        }
        this.model = newValue;
        newValue.addDataGridModelListener(this.modelListener);
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRowIndex(Number newValue) {
        if (this.rowPercent != null) {
            this.setRowPercent(null);
        }
        Number oldValue = this.rowIndex;
        this.rowIndex = newValue;
        this.firePropertyChange(ROW_INDEX_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setRowPercent(Number newValue) {
        if (this.rowIndex != null) {
            this.setRowIndex(null);
        }
        Number oldValue = this.rowPercent;
        this.rowPercent = newValue;
        this.firePropertyChange(ROW_PERCENT_CHANGED_PROPERTY, oldValue, newValue);
    }

    private static class EmptyDataGridModel
    extends AbstractDataGridModel {
        private EmptyDataGridModel() {
        }

        public Object get(int column, int row) {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }

        public int getRowCount() {
            return 0;
        }
    }
}

