/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.menu;

import java.util.EventListener;
import nextapp.echo.app.Component;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.extras.app.menu.DefaultMenuModel;
import nextapp.echo.extras.app.menu.DefaultMenuStateModel;
import nextapp.echo.extras.app.menu.ItemModel;
import nextapp.echo.extras.app.menu.MenuModel;
import nextapp.echo.extras.app.menu.MenuStateModel;
import nextapp.echo.extras.app.menu.OptionModel;
import nextapp.echo.extras.app.menu.RadioOptionModel;
import nextapp.echo.extras.app.menu.ToggleOptionModel;

public abstract class AbstractMenuComponent
extends Component {
    public static final String INPUT_ACTION = "action";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String STATE_MODEL_CHANGED_PROPERTY = "stateModel";
    public static final String ACTION_LISTENERS_CHANGED_PROPERTY = "actionListeners";
    public static final String PROPERTY_ANIMATION_TIME = "animationTime";
    public static final int DEFAULT_ANIMATION_TIME = 0;
    private MenuModel model;
    private MenuStateModel stateModel;
    private ChangeListener stateModelListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            AbstractMenuComponent.this.firePropertyChange(AbstractMenuComponent.STATE_MODEL_CHANGED_PROPERTY, null, AbstractMenuComponent.this.stateModel);
        }
    };

    public AbstractMenuComponent(MenuModel model, MenuStateModel stateModel) {
        this.setModel(model == null ? new DefaultMenuModel() : model);
        this.setStateModel(stateModel == null ? new DefaultMenuStateModel() : stateModel);
    }

    public void addActionListener(ActionListener l) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)l);
    }

    public int getAnimationTime() {
        Integer animationTime = (Integer)this.get(PROPERTY_ANIMATION_TIME);
        return animationTime == null ? 0 : animationTime;
    }

    public boolean hasActionListeners() {
        return this.hasEventListenerList() && this.getEventListenerList().getListenerCount(ActionListener.class) != 0;
    }

    private void deselectGroup(MenuModel menuModel, Object groupId, Object newSelectionId) {
        int count = menuModel.getItemCount();
        for (int i = 0; i < count; ++i) {
            RadioOptionModel radioOptionModel;
            ItemModel itemModel = menuModel.getItem(i);
            if (itemModel instanceof MenuModel) {
                this.deselectGroup((MenuModel)itemModel, groupId, newSelectionId);
                continue;
            }
            if (!(itemModel instanceof RadioOptionModel) || (radioOptionModel = (RadioOptionModel)itemModel).getGroupId() == null || !radioOptionModel.getGroupId().equals(groupId)) continue;
            this.getStateModel().setSelected(radioOptionModel.getId(), false);
        }
    }

    public void doAction(OptionModel optionModel) {
        if (this.getStateModel() != null && !this.getStateModel().isEnabled(optionModel.getId())) {
            return;
        }
        if (this.getStateModel() != null && optionModel instanceof ToggleOptionModel) {
            if (optionModel instanceof RadioOptionModel) {
                RadioOptionModel radioOptionModel = (RadioOptionModel)optionModel;
                this.deselectGroup(this.getModel(), radioOptionModel.getGroupId(), radioOptionModel.getId());
                this.getStateModel().setSelected(radioOptionModel.getId(), true);
            } else {
                ToggleOptionModel toggleOptionModel = (ToggleOptionModel)optionModel;
                this.getStateModel().setSelected(toggleOptionModel.getId(), !this.getStateModel().isSelected(toggleOptionModel.getId()));
            }
            this.firePropertyChange(STATE_MODEL_CHANGED_PROPERTY, null, null);
        }
        this.fireActionPerformed(optionModel);
    }

    protected void fireActionPerformed(OptionModel optionModel) {
        if (!this.hasEventListenerList()) {
            return;
        }
        ActionEvent e = new ActionEvent((Object)this, optionModel.getId());
        EventListener[] listeners = this.getEventListenerList().getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public MenuModel getModel() {
        return this.model;
    }

    public MenuStateModel getStateModel() {
        return this.stateModel;
    }

    public void processInput(String name, Object value) {
        if (INPUT_ACTION.equals(name)) {
            OptionModel optionModel = (OptionModel)value;
            this.doAction(optionModel);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)l);
    }

    public void setAnimationTime(int newValue) {
        this.set(PROPERTY_ANIMATION_TIME, new Integer(newValue));
    }

    public void setModel(MenuModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Model may not be null.");
        }
        MenuModel oldValue = this.model;
        this.model = newValue;
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setStateModel(MenuStateModel newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("State model may not be null.");
        }
        MenuStateModel oldValue = this.stateModel;
        if (oldValue != null) {
            oldValue.removeChangeListener(this.stateModelListener);
        }
        this.stateModel = newValue;
        newValue.addChangeListener(this.stateModelListener);
        this.firePropertyChange(STATE_MODEL_CHANGED_PROPERTY, oldValue, newValue);
    }
}

