/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.serial.property;

import nextapp.echo.app.ImageReference;
import nextapp.echo.app.serial.PropertyPeerFactory;
import nextapp.echo.app.serial.SerialContext;
import nextapp.echo.app.serial.SerialException;
import nextapp.echo.app.serial.SerialPropertyPeer;
import nextapp.echo.app.serial.property.ImageReferencePeer;
import nextapp.echo.app.util.Context;
import nextapp.echo.extras.app.menu.ItemModel;
import nextapp.echo.extras.app.menu.MenuModel;
import nextapp.echo.extras.app.menu.OptionModel;
import nextapp.echo.extras.app.menu.RadioOptionModel;
import nextapp.echo.extras.app.menu.SeparatorModel;
import nextapp.echo.extras.app.menu.ToggleOptionModel;
import org.w3c.dom.Element;

public class ItemModelPeer
implements SerialPropertyPeer {
    public Object toProperty(Context context, Class objectClass, Element propertyElement) throws SerialException {
        throw new UnsupportedOperationException();
    }

    public void toXml(Context context, Class objectClass, Element propertyElement, Object propertyValue) throws SerialException {
        ItemModel itemModel = (ItemModel)propertyValue;
        if (itemModel instanceof MenuModel) {
            this.toXml(context, objectClass, propertyElement, (MenuModel)itemModel);
        } else if (itemModel instanceof OptionModel) {
            this.toXml(context, objectClass, propertyElement, (OptionModel)itemModel);
        } else if (itemModel instanceof SeparatorModel) {
            this.toXml(context, objectClass, propertyElement, (SeparatorModel)itemModel);
        } else {
            throw new RuntimeException("Unsupported model type: " + itemModel.getClass().getName());
        }
    }

    private void toXml(Context context, Class objectClass, Element propertyElement, MenuModel model) throws SerialException {
        SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
        propertyElement.setAttribute("t", "Extras.Serial.MenuModel");
        this.writeIdIconAndText(context, objectClass, propertyElement, model.getId(), model.getText(), model.getIcon());
        int length = model.getItemCount();
        for (int i = 0; i < length; ++i) {
            Element subElement = serialContext.getDocument().createElement("item");
            this.toXml(context, objectClass, subElement, model.getItem(i));
            propertyElement.appendChild(subElement);
        }
    }

    private void toXml(Context context, Class objectClass, Element propertyElement, OptionModel model) throws SerialException {
        String type = model instanceof ToggleOptionModel ? (model instanceof RadioOptionModel ? "RadioOptionModel" : "ToggleOptionModel") : "OptionModel";
        propertyElement.setAttribute("t", "Extras.Serial." + type);
        this.writeIdIconAndText(context, objectClass, propertyElement, model.getId(), model.getText(), model.getIcon());
    }

    private void toXml(Context context, Class objectClass, Element propertyElement, SeparatorModel model) {
        propertyElement.setAttribute("t", "Extras.Serial.SeparatorModel");
    }

    private void writeIdIconAndText(Context context, Class objectClass, Element propertyElement, String id, String text, ImageReference icon) throws SerialException {
        if (id != null) {
            propertyElement.setAttribute("id", id);
        }
        if (text != null) {
            propertyElement.setAttribute("text", text);
        }
        if (icon != null) {
            SerialContext serialContext = (SerialContext)context.get(SerialContext.class);
            Element iconElement = serialContext.getDocument().createElement("icon");
            this.getPeer(context, icon).toXml(context, objectClass, iconElement, (Object)icon);
            propertyElement.appendChild(iconElement);
        }
    }

    private ImageReferencePeer getPeer(Context context, ImageReference imageReference) {
        PropertyPeerFactory propertyPeerFactory = (PropertyPeerFactory)context.get(PropertyPeerFactory.class);
        SerialPropertyPeer peer = propertyPeerFactory.getPeerForProperty(imageReference.getClass());
        return (ImageReferencePeer)peer;
    }
}

