/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.extras.app.tree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.LinkedHashSet;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.app.event.EventListenerList;
import nextapp.echo.extras.app.tree.TreePath;
import nextapp.echo.extras.app.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel
implements TreeSelectionModel {
    private EventListenerList listenerList = new EventListenerList();
    private int selectionMode = 0;
    private LinkedHashSet paths = new LinkedHashSet();

    public void addChangeListener(ChangeListener l) {
        this.listenerList.addListener(ChangeListener.class, (EventListener)l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.addListener(PropertyChangeListener.class, (EventListener)l);
    }

    public void addSelectionPath(TreePath path) {
        if (path == null) {
            return;
        }
        this.addSelectionPaths(new TreePath[]{path});
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        if (0 == this.getSelectionMode()) {
            if (paths[0].equals(this.getSelectionPath())) {
                return;
            }
            boolean changed = !this.paths.isEmpty();
            this.paths.clear();
            if (changed |= this.paths.add(paths[0])) {
                this.fireValueChanged();
            }
        } else if (this.paths.addAll(Arrays.asList(paths))) {
            this.fireValueChanged();
        }
    }

    public void clearSelection() {
        if (!this.isSelectionEmpty()) {
            this.paths.clear();
            this.fireValueChanged();
        }
    }

    protected void fireValueChanged() {
        ChangeEvent e = new ChangeEvent((Object)this);
        EventListener[] listeners = this.listenerList.getListeners(ChangeListener.class);
        for (int index = 0; index < listeners.length; ++index) {
            ((ChangeListener)listeners[index]).stateChanged(e);
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public TreePath getSelectionPath() {
        if (this.isSelectionEmpty()) {
            return null;
        }
        return (TreePath)this.paths.iterator().next();
    }

    public TreePath[] getSelectionPaths() {
        return this.paths.toArray(new TreePath[this.paths.size()]);
    }

    public boolean isPathSelected(TreePath path) {
        return this.paths.contains(path);
    }

    public boolean isSelectionEmpty() {
        return this.paths.isEmpty();
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.removeListener(ChangeListener.class, (EventListener)l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listenerList.removeListener(PropertyChangeListener.class, (EventListener)l);
    }

    public void removeSelectionPath(TreePath path) {
        if (this.paths.remove(path)) {
            this.fireValueChanged();
        }
    }

    public void removeSelectionPaths(TreePath[] paths) {
        if (this.paths.removeAll(Arrays.asList(paths))) {
            this.fireValueChanged();
        }
    }

    public void setSelectionMode(int newValue) {
        if (this.selectionMode == newValue) {
            return;
        }
        int countBefore = this.paths.size();
        if (newValue == 0 && countBefore > 1) {
            TreePath newPath = this.getSelectionPath();
            this.paths.clear();
            this.paths.add(newPath);
            this.fireValueChanged();
        }
        int oldValue = this.selectionMode;
        this.selectionMode = newValue;
        this.firePropertyChange("selectionMode", oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        EventListener[] listeners = this.listenerList.getListeners(PropertyChangeListener.class);
        if (listeners.length == 0) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, new Integer(oldValue), new Integer(newValue));
        for (int i = 0; i < listeners.length; ++i) {
            PropertyChangeListener l = (PropertyChangeListener)listeners[i];
            l.propertyChange(evt);
        }
    }

    public void setSelectionPath(TreePath path) {
        boolean wasEmpty = this.isSelectionEmpty();
        this.paths.clear();
        this.addSelectionPath(path);
        if (!wasEmpty && this.isSelectionEmpty()) {
            this.fireValueChanged();
        }
    }

    public void setSelectionPaths(TreePath[] paths) {
        boolean wasEmpty = this.isSelectionEmpty();
        this.paths.clear();
        this.addSelectionPaths(paths);
        if (!wasEmpty && this.isSelectionEmpty()) {
            this.fireValueChanged();
        }
    }
}

