/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.filetransfer.receiver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BandwidthAllocator {
    private static final int BUFFER_SIZE = 4096;
    private Set allocations = new HashSet();
    private int interval = 25;
    private long lastAllocationTime = 0L;
    private boolean throttling = false;
    private int bandwidth;
    private int bytesPerInterval;

    public BandwidthAllocator() {
        this.setBandwidth(0x100000);
    }

    public BandwidthAllocator(int targetBytesPerSecond) {
        this();
        this.setThrottling(true);
        this.setBandwidth(targetBytesPerSecond);
    }

    private synchronized void allocate() {
        long time = System.currentTimeMillis();
        if (time - (long)this.interval < this.lastAllocationTime) {
            return;
        }
        int bytes = this.bytesPerInterval / this.allocations.size();
        Iterator it = this.allocations.iterator();
        while (it.hasNext()) {
            Allocation allocation = (Allocation)it.next();
            allocation.remainingBytes = bytes;
        }
        this.lastAllocationTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copy(Tracker tracker, InputStream input, OutputStream output) throws IOException {
        Allocation handle = this.create();
        try {
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                if (tracker.isAborted()) {
                    return;
                }
                output.write(buffer, 0, n);
                if (tracker != null) {
                    tracker.bytesTransferred(n);
                }
                if (!this.throttling) continue;
                Allocation allocation = handle;
                allocation.remainingBytes = allocation.remainingBytes - n;
                while (handle.remainingBytes <= 0) {
                    this.allocate();
                    if (handle.remainingBytes > 0) continue;
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                continue;
                return;
            }
        }
        finally {
            this.remove(handle);
        }
    }

    private synchronized Allocation create() {
        Allocation handle = new Allocation();
        this.allocations.add(handle);
        return handle;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }

    public boolean isThrottling() {
        return this.throttling;
    }

    private synchronized void remove(Allocation handle) {
        this.allocations.remove(handle);
    }

    public void setThrottling(boolean newValue) {
        this.throttling = newValue;
    }

    public void setBandwidth(int newValue) {
        if (newValue > 0) {
            this.bandwidth = newValue;
            this.bytesPerInterval = newValue / (1000 / this.interval);
        }
    }

    public static interface Tracker {
        public void bytesTransferred(long var1);

        public boolean isAborted();
    }

    private static class Allocation {
        private int remainingBytes;

        private Allocation() {
        }
    }
}

