/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.filetransfer.receiver;

import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.filetransfer.model.Upload;
import nextapp.echo.filetransfer.model.UploadProcess;
import nextapp.echo.filetransfer.model.event.UploadProcessEvent;
import nextapp.echo.filetransfer.model.event.UploadProcessListener;
import nextapp.echo.filetransfer.receiver.BandwidthAllocator;
import nextapp.echo.filetransfer.receiver.UploadProcessManager;
import nextapp.echo.filetransfer.receiver.UploadProcessor;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;

public class JakartaUploadProcessor
implements UploadProcessor {
    private static final int DEFAULT_MEMORY_CACHE_THRESHOLD = 16384;
    private static final File DEFAULT_TEMP_LOCATION = new File(System.getProperty("java.io.tmpdir", "."));
    private static final int DEFAULT_UPLOAD_SIZE_LIMIT = 0x1400000;
    public static final short NO_SIZE_LIMIT = -1;
    private static final int PROGRESS_INTERVAL = 250;
    private static final BandwidthAllocator allocator = new BandwidthAllocator(0x300000);

    public static int getBandwidth() {
        if (allocator.isThrottling()) {
            return allocator.getBandwidth();
        }
        return 0;
    }

    public static void setBandwidth(int newValue) {
        if (newValue < 0) {
            throw new IllegalArgumentException("Invalid bandwidth value.");
        }
        if (newValue == 0) {
            allocator.setThrottling(false);
        } else {
            allocator.setThrottling(true);
            allocator.setBandwidth(newValue);
        }
    }

    public File getDiskCacheLocation() {
        return DEFAULT_TEMP_LOCATION;
    }

    public long getFileUploadSizeLimit() {
        return 0x1400000L;
    }

    public int getMemoryCacheThreshold() {
        return 16384;
    }

    public void processUpload(HttpServletRequest request, String id) {
        Instance instance = new Instance(request, id);
        instance.process();
    }

    private class Instance
    implements ProgressListener {
        private boolean aborted = false;
        private Upload currentUpload;
        private long nextProgressTime = 0L;
        private BandwidthAllocator.Tracker allocatorTracker = new BandwidthAllocator.Tracker(){

            public void bytesTransferred(long bytes) {
            }

            public boolean isAborted() {
                return Instance.this.aborted;
            }
        };
        private HttpServletRequest request;
        private String id;
        private UploadProcess uploadProcess = null;
        private UploadProcessListener uploadProcessListener = new UploadProcessListener(){

            public void uploadStart(UploadProcessEvent e) {
            }

            public void uploadProgress(UploadProcessEvent e) {
            }

            public void uploadComplete(UploadProcessEvent e) {
            }

            public void uploadCancel(UploadProcessEvent e) {
                Instance.this.aborted = true;
            }
        };

        private Instance(HttpServletRequest request, String id) {
            this.request = request;
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process() {
            DiskFileItemFactory itemFactory = new DiskFileItemFactory();
            itemFactory.setRepository(JakartaUploadProcessor.this.getDiskCacheLocation());
            itemFactory.setSizeThreshold(JakartaUploadProcessor.this.getMemoryCacheThreshold());
            String encoding = this.request.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)itemFactory);
            sfu.setHeaderEncoding(encoding);
            sfu.setProgressListener((ProgressListener)this);
            if (JakartaUploadProcessor.this.getFileUploadSizeLimit() != -1L) {
                sfu.setSizeMax(JakartaUploadProcessor.this.getFileUploadSizeLimit());
            }
            this.uploadProcess = UploadProcessManager.get(this.request, this.id, true);
            this.uploadProcess.addProcessListener(this.uploadProcessListener);
            this.currentUpload = null;
            try {
                FileItemIterator iter = sfu.getItemIterator(this.request);
                int uploadIndex = 0;
                while (!this.aborted && iter.hasNext()) {
                    FileItemStream stream = iter.next();
                    if (stream.isFormField()) continue;
                    this.currentUpload = this.uploadProcess.createUpload();
                    String fileName = FilenameUtils.getName((String)stream.getName());
                    FileItem item = itemFactory.createItem(stream.getFieldName(), stream.getContentType(), false, stream.getName());
                    this.uploadProcess.configure(this.currentUpload, item.getContentType(), fileName);
                    this.uploadProcess.start(this.currentUpload);
                    if (this.currentUpload.getStatus() == 0) {
                        allocator.copy(this.allocatorTracker, stream.openStream(), item.getOutputStream());
                        this.uploadProcess.complete(this.currentUpload, item.getInputStream(), item.getSize());
                    }
                    ++uploadIndex;
                }
            }
            catch (FileUploadBase.SizeLimitExceededException ex) {
                if (this.currentUpload == null) {
                    this.uploadProcess.createUpload();
                }
                this.uploadProcess.setStatus(4);
            }
            catch (IOException ex) {
                this.uploadProcess.setStatus(3);
            }
            catch (FileUploadException ex) {
                this.uploadProcess.setStatus(3);
            }
            finally {
                this.uploadProcess.removeProcessListener(this.uploadProcessListener);
            }
        }

        public void update(long pBytesRead, long pContentLength, int pItems) {
            if (!this.uploadProcess.isInitialized()) {
                this.uploadProcess.init(pContentLength);
            }
            if (this.currentUpload != null && System.currentTimeMillis() > this.nextProgressTime) {
                this.uploadProcess.progress(this.currentUpload, pBytesRead);
                this.nextProgressTime = System.currentTimeMillis() + 250L;
            }
        }
    }
}

