/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.filetransfer.webcontainer;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import nextapp.echo.filetransfer.app.AbstractUploadSelect;
import nextapp.echo.filetransfer.model.UploadProcess;
import nextapp.echo.filetransfer.receiver.UploadProcessManager;
import nextapp.echo.filetransfer.webcontainer.AbstractUploadSelectPeer;
import nextapp.echo.filetransfer.webcontainer.BaseUploadService;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.SynchronizePeerFactory;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadReceiverService
extends BaseUploadService {
    public static final Service INSTANCE = new UploadReceiverService();
    private static boolean installed;

    private UploadReceiverService() {
    }

    public static void install() {
        if (!installed) {
            installed = true;
        }
    }

    public String getId() {
        return "EchoFileTransfer.UploadReceiver";
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn, String processId) throws IOException {
        HttpServletRequest request = conn.getRequest();
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            UploadReceiverService.serviceBadRequest(conn, "Request must contain multipart content.");
            return;
        }
        UploadProcess process = UploadProcessManager.get((HttpServletRequest)conn.getRequest(), (String)processId, (boolean)true);
        String componentId = request.getParameter("cid");
        AbstractUploadSelect uploadSelect = (AbstractUploadSelect)conn.getUserInstance().getComponentByClientRenderId(componentId);
        uploadSelect.setUploadProcess(process);
        AbstractUploadSelectPeer uploadSelectPeer = (AbstractUploadSelectPeer)SynchronizePeerFactory.getPeerForComponent(uploadSelect.getClass());
        uploadSelectPeer.getUploadProcessor(uploadSelect).processUpload(request, processId);
    }

    static {
        WebContainerServlet.getServiceRegistry().add(INSTANCE);
        installed = false;
    }
}

