/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.UserInstance;
import nextapp.echo.webcontainer.UserInstanceContainer;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.WebContainerServletException;

public class Connection {
    private static final String USER_INSTANCE_CONTAINER_SESSION_KEY_PREFIX = "EchoUserInstanceContainer";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private WebContainerServlet servlet;
    private UserInstance userInstance;
    private UserInstanceContainer userInstanceContainer;
    private Map propertyMap;
    private String uiid;

    Connection(WebContainerServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session;
        String contentType;
        this.servlet = servlet;
        this.request = request;
        this.response = response;
        if (servlet.getInstanceMode() == 1) {
            this.uiid = request.getParameter("uiid");
        }
        if ((contentType = request.getContentType()) != null && contentType.startsWith(ContentType.MULTIPART_FORM_DATA.getMimeType()) && WebContainerServlet.getMultipartRequestWrapper() != null) {
            this.request = WebContainerServlet.getMultipartRequestWrapper().getWrappedRequest(request);
        }
        if ((session = request.getSession(false)) != null) {
            this.userInstanceContainer = (UserInstanceContainer)session.getAttribute(this.getUserInstanceContainerSessionKey());
            if (this.userInstanceContainer != null) {
                this.userInstance = this.userInstanceContainer.getUserInstanceById(this.uiid);
            }
        }
    }

    void disposeUserInstance() {
        if (this.userInstanceContainer != null && this.userInstance != null) {
            this.userInstanceContainer.unloadUserInstance(this.userInstance);
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException ex) {
            throw new WebContainerServletException("Unable to get PrintWriter.", ex);
        }
    }

    public Object getProperty(String key) {
        return this.propertyMap == null ? null : this.propertyMap.get(key);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    private String getUserInstanceContainerSessionKey() {
        return "EchoUserInstanceContainer:" + this.servlet.getServletName();
    }

    public WebContainerServlet getServlet() {
        return this.servlet;
    }

    public UserInstance getUserInstance() {
        return this.userInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInstance getUserInstance(String windowId, String initId) {
        if (this.userInstanceContainer == null) {
            return null;
        }
        UserInstanceContainer userInstanceContainer = this.userInstanceContainer;
        synchronized (userInstanceContainer) {
            if (this.userInstance == null && windowId != null) {
                this.userInstance = this.userInstanceContainer.loadUserInstance(windowId, initId);
            }
        }
        return this.userInstance;
    }

    public UserInstanceContainer getUserInstanceContainer() {
        return this.userInstanceContainer;
    }

    public PrintWriter getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException ex) {
            throw new WebContainerServletException("Unable to get PrintWriter.", ex);
        }
    }

    void initUserInstanceContainer(UserInstanceContainer userInstanceContainer) {
        this.userInstanceContainer = userInstanceContainer;
        userInstanceContainer.setServletUri(this.request.getRequestURI());
        HttpSession session = this.request.getSession(true);
        session.setAttribute(this.getUserInstanceContainerSessionKey(), (Object)userInstanceContainer);
    }

    public void setContentType(ContentType contentType) {
        UserInstance userInstance = this.getUserInstance();
        if (contentType.isBinary()) {
            this.response.setContentType(contentType.getMimeType());
        } else if (userInstance == null) {
            this.response.setContentType(contentType.getMimeType() + "; charset=utf-8");
        } else {
            this.response.setContentType(contentType.getMimeType() + "; charset=" + userInstance.getCharacterEncoding());
        }
    }

    public void setProperty(String key, Object value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(key, value);
    }
}

