/*
 * Decompiled with CFR 0.152.
 */
package nextapp.echo.webcontainer.sync.component;

import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.WindowPane;
import nextapp.echo.app.update.ClientUpdateManager;
import nextapp.echo.app.util.Context;
import nextapp.echo.webcontainer.AbstractComponentSynchronizePeer;
import nextapp.echo.webcontainer.ContentType;
import nextapp.echo.webcontainer.ServerMessage;
import nextapp.echo.webcontainer.Service;
import nextapp.echo.webcontainer.WebContainerServlet;
import nextapp.echo.webcontainer.service.JavaScriptService;

public class WindowPanePeer
extends AbstractComponentSynchronizePeer {
    private static final Service WINDOW_PANE_SERVICE = JavaScriptService.forResource("Echo.WindowPane", "nextapp/echo/webcontainer/resource/Sync.WindowPane.js");

    public WindowPanePeer() {
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("close", null));
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("maximize", null));
        this.addEvent(new AbstractComponentSynchronizePeer.EventPeer("minimize", null));
        this.addOutputProperty("modal");
    }

    public String getClientComponentType(boolean mode) {
        return mode ? "WP" : "WindowPane";
    }

    public Class getComponentClass() {
        return WindowPane.class;
    }

    public Class getInputPropertyClass(String propertyName) {
        if ("positionX".equals(propertyName)) {
            return Extent.class;
        }
        if ("positionY".equals(propertyName)) {
            return Extent.class;
        }
        if ("width".equals(propertyName)) {
            return Extent.class;
        }
        if ("height".equals(propertyName)) {
            return Extent.class;
        }
        if ("zIndex".equals(propertyName)) {
            return Integer.class;
        }
        return null;
    }

    public Object getOutputProperty(Context context, Component component, String propertyName, int propertyIndex) {
        WindowPane windowPane = (WindowPane)component;
        if ("modal".equals(propertyName)) {
            return windowPane.isModal();
        }
        return super.getOutputProperty(context, component, propertyName, propertyIndex);
    }

    public void init(Context context, Component component) {
        super.init(context, component);
        ServerMessage serverMessage = (ServerMessage)context.get(ServerMessage.class);
        serverMessage.addLibrary(WINDOW_PANE_SERVICE.getId());
    }

    public void storeInputProperty(Context context, Component component, String propertyName, int index, Object newValue) {
        ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
        if ("positionX".equals(propertyName)) {
            clientUpdateManager.setComponentProperty(component, "positionX", newValue);
        } else if ("positionY".equals(propertyName)) {
            clientUpdateManager.setComponentProperty(component, "positionY", newValue);
        } else if ("width".equals(propertyName)) {
            clientUpdateManager.setComponentProperty(component, "width", newValue);
        } else if ("height".equals(propertyName)) {
            clientUpdateManager.setComponentProperty(component, "height", newValue);
        } else if ("zIndex".equals(propertyName)) {
            clientUpdateManager.setComponentProperty(component, "zIndex", newValue);
        }
    }

    public void processEvent(Context context, Component component, String eventType, Object eventData) {
        ClientUpdateManager clientUpdateManager = (ClientUpdateManager)context.get(ClientUpdateManager.class);
        if ("close".equals(eventType)) {
            clientUpdateManager.setComponentAction(component, "close", null);
        } else if ("minimize".equals(eventType)) {
            clientUpdateManager.setComponentAction(component, "minimize", null);
        } else if ("maximize".equals(eventType)) {
            clientUpdateManager.setComponentAction(component, "maximize", null);
        }
    }

    static {
        WebContainerServlet.getServiceRegistry().add(WINDOW_PANE_SERVICE);
        WebContainerServlet.getResourceRegistry().add("Echo", "resource/WindowPaneClose.gif", ContentType.IMAGE_GIF);
        WebContainerServlet.getResourceRegistry().add("Echo", "resource/WindowPaneMaximize.gif", ContentType.IMAGE_GIF);
        WebContainerServlet.getResourceRegistry().add("Echo", "resource/WindowPaneMinimize.gif", ContentType.IMAGE_GIF);
    }
}

