/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class ResourceOwnerPasswordCredentialsGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.PASSWORD;
    private final String username;
    private final Secret password;

    public ResourceOwnerPasswordCredentialsGrant(String username, Secret password) {
        super(GRANT_TYPE);
        if (username == null) {
            throw new IllegalArgumentException("The username must not be null");
        }
        this.username = username;
        if (password == null) {
            throw new IllegalArgumentException("The password must not be null");
        }
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("username", this.username);
        params.put("password", this.password.getValue());
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceOwnerPasswordCredentialsGrant that = (ResourceOwnerPasswordCredentialsGrant)o;
        if (!this.username.equals(that.username)) {
            return false;
        }
        return this.password.equals(that.password);
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    public static ResourceOwnerPasswordCredentialsGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        if (!GrantType.parse(grantTypeString).equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
        }
        String username = params.get("username");
        if (username == null || username.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"username\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        String passwordString = params.get("password");
        if (passwordString == null || passwordString.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"password\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        Secret password = new Secret(passwordString);
        return new ResourceOwnerPasswordCredentialsGrant(username, password);
    }
}

