/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.jose.util.DateUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class TokenIntrospectionSuccessResponse
extends TokenIntrospectionResponse
implements SuccessResponse {
    private final JSONObject params;

    public TokenIntrospectionSuccessResponse(JSONObject params) {
        if (!(params.get((Object)"active") instanceof Boolean)) {
            throw new IllegalArgumentException("Missing / invalid boolean active parameter");
        }
        this.params = params;
    }

    public boolean isActive() {
        try {
            return JSONObjectUtils.getBoolean(this.params, "active");
        }
        catch (ParseException e) {
            return false;
        }
    }

    public Scope getScope() {
        try {
            return Scope.parse(JSONObjectUtils.getString(this.params, "scope"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public ClientID getClientID() {
        try {
            return new ClientID(JSONObjectUtils.getString(this.params, "client_id"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getUsername() {
        try {
            return JSONObjectUtils.getString(this.params, "username");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public AccessTokenType getTokenType() {
        try {
            return new AccessTokenType(JSONObjectUtils.getString(this.params, "token_type"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getExpirationTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(this.params, "exp"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getIssueTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(this.params, "iat"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Date getNotBeforeTime() {
        try {
            return DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(this.params, "nbf"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Subject getSubject() {
        try {
            return new Subject(JSONObjectUtils.getString(this.params, "sub"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public List<Audience> getAudience() {
        try {
            return Audience.create(JSONObjectUtils.getStringList(this.params, "aud"));
        }
        catch (ParseException e) {
            try {
                return new Audience(JSONObjectUtils.getString(this.params, "aud")).toSingleAudienceList();
            }
            catch (ParseException e2) {
                return null;
            }
        }
    }

    public Issuer getIssuer() {
        try {
            return new Issuer(JSONObjectUtils.getString(this.params, "iss"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public JWTID getJWTID() {
        try {
            return new JWTID(JSONObjectUtils.getString(this.params, "jti"));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        return new JSONObject((Map)this.params);
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpResponse.setContent(this.params.toJSONString());
        return httpResponse;
    }

    public static TokenIntrospectionSuccessResponse parse(JSONObject jsonObject) throws ParseException {
        try {
            return new TokenIntrospectionSuccessResponse(jsonObject);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public static TokenIntrospectionSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return TokenIntrospectionSuccessResponse.parse(jsonObject);
    }

    public static class Builder {
        private final boolean active;
        private Scope scope;
        private ClientID clientID;
        private String username;
        private AccessTokenType tokenType;
        private Date exp;
        private Date iat;
        private Date nbf;
        private Subject sub;
        private List<Audience> audList;
        private Issuer iss;
        private JWTID jti;
        private final JSONObject customParams = new JSONObject();

        public Builder(boolean active) {
            this.active = active;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder clientID(ClientID clientID) {
            this.clientID = clientID;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder tokenType(AccessTokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder expirationTime(Date exp) {
            this.exp = exp;
            return this;
        }

        public Builder issueTime(Date iat) {
            this.iat = iat;
            return this;
        }

        public Builder notBeforeTime(Date nbf) {
            this.nbf = nbf;
            return this;
        }

        public Builder subject(Subject sub) {
            this.sub = sub;
            return this;
        }

        public Builder audience(List<Audience> audList) {
            this.audList = audList;
            return this;
        }

        public Builder issuer(Issuer iss) {
            this.iss = iss;
            return this;
        }

        public Builder jwtID(JWTID jti) {
            this.jti = jti;
            return this;
        }

        public Builder parameter(String name, Object value) {
            if (value != null) {
                this.customParams.put((Object)name, value);
            }
            return this;
        }

        public TokenIntrospectionSuccessResponse build() {
            JSONObject o = new JSONObject();
            o.put((Object)"active", (Object)this.active);
            if (this.scope != null) {
                o.put((Object)"scope", (Object)this.scope.toString());
            }
            if (this.clientID != null) {
                o.put((Object)"client_id", (Object)this.clientID.getValue());
            }
            if (this.username != null) {
                o.put((Object)"username", (Object)this.username);
            }
            if (this.tokenType != null) {
                o.put((Object)"token_type", (Object)this.tokenType.getValue());
            }
            if (this.exp != null) {
                o.put((Object)"exp", (Object)DateUtils.toSecondsSinceEpoch((Date)this.exp));
            }
            if (this.iss != null) {
                o.put((Object)"iat", (Object)DateUtils.toSecondsSinceEpoch((Date)this.iat));
            }
            if (this.nbf != null) {
                o.put((Object)"nbf", (Object)DateUtils.toSecondsSinceEpoch((Date)this.nbf));
            }
            if (this.sub != null) {
                o.put((Object)"sub", (Object)this.sub.getValue());
            }
            if (this.audList != null) {
                o.put((Object)"aud", Audience.toStringList(this.audList));
            }
            if (this.iss != null) {
                o.put((Object)"iss", (Object)this.iss.getValue());
            }
            if (this.jti != null) {
                o.put((Object)"jti", (Object)this.jti.getValue());
            }
            o.putAll((Map)this.customParams);
            return new TokenIntrospectionSuccessResponse(o);
        }
    }
}

