/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth.verifier;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.auth.verifier.ClientCredentialsSelector;
import com.nimbusds.oauth2.sdk.auth.verifier.Context;
import com.nimbusds.oauth2.sdk.auth.verifier.JWTAuthenticationClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ClientAuthenticationVerifier<T> {
    private final ClientCredentialsSelector<T> clientCredentialsSelector;
    private final JWTAuthenticationClaimsSetVerifier claimsSetVerifier;
    private final JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();

    public ClientAuthenticationVerifier(ClientCredentialsSelector<T> clientCredentialsSelector, Set<Audience> expectedAudience) {
        this.claimsSetVerifier = new JWTAuthenticationClaimsSetVerifier(expectedAudience);
        if (clientCredentialsSelector == null) {
            throw new IllegalArgumentException("The client credentials selector must not be null");
        }
        this.clientCredentialsSelector = clientCredentialsSelector;
    }

    public ClientCredentialsSelector<T> getClientCredentialsSelector() {
        return this.clientCredentialsSelector;
    }

    public Set<Audience> getExpectedAudience() {
        return this.claimsSetVerifier.getExpectedAudience();
    }

    public boolean verify(ClientAuthentication clientAuth, Context<T> context) throws JOSEException {
        if (clientAuth instanceof PlainClientSecret) {
            List<Secret> secretCandidates = this.clientCredentialsSelector.selectClientSecrets(clientAuth.getClientID(), clientAuth.getMethod(), context);
            if (secretCandidates == null) {
                return false;
            }
            PlainClientSecret plainAuth = (PlainClientSecret)clientAuth;
            for (Secret candidate : secretCandidates) {
                if (!plainAuth.getClientSecret().equals(candidate)) continue;
                return true;
            }
            return false;
        }
        if (clientAuth instanceof ClientSecretJWT) {
            ClientSecretJWT jwtAuth = (ClientSecretJWT)clientAuth;
            try {
                this.claimsSetVerifier.verify(jwtAuth.getJWTAuthenticationClaimsSet().toJWTClaimsSet());
            }
            catch (BadJWTException badJWTException) {
                return false;
            }
            List<Secret> secretCandidates = this.clientCredentialsSelector.selectClientSecrets(clientAuth.getClientID(), clientAuth.getMethod(), context);
            if (secretCandidates == null) {
                return false;
            }
            SignedJWT assertion = jwtAuth.getClientAssertion();
            for (Secret candidate : secretCandidates) {
                boolean valid = assertion.verify((JWSVerifier)new MACVerifier(candidate.getValueBytes()));
                if (!valid) continue;
                return true;
            }
            return false;
        }
        if (clientAuth instanceof PrivateKeyJWT) {
            PrivateKeyJWT jwtAuth = (PrivateKeyJWT)clientAuth;
            try {
                this.claimsSetVerifier.verify(jwtAuth.getJWTAuthenticationClaimsSet().toJWTClaimsSet());
            }
            catch (BadJWTException badJWTException) {
                return false;
            }
            List<PublicKey> keyCandidates = this.clientCredentialsSelector.selectPublicKeys(jwtAuth.getClientID(), jwtAuth.getMethod(), jwtAuth.getClientAssertion().getHeader(), context);
            if (keyCandidates == null) {
                return false;
            }
            SignedJWT assertion = jwtAuth.getClientAssertion();
            for (PublicKey candidate : keyCandidates) {
                JWSVerifier jwsVerifier;
                boolean valid;
                if (candidate == null || !(valid = assertion.verify(jwsVerifier = this.jwsVerifierFactory.createJWSVerifier(jwtAuth.getClientAssertion().getHeader(), (Key)candidate)))) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Unexpected client authentication: " + clientAuth.getMethod());
    }
}

